/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.impl;

import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NumberUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class GroupedTestableEntities
implements TestableEntity {
    private final Collection<TestableEntity> children;

    public GroupedTestableEntities(@NotNull Collection<TestableEntity> children2) {
        Validate.isTrue((!children2.isEmpty() ? 1 : 0) != 0, (String)"Group must have at least one child!");
        this.children = children2;
    }

    @Override
    public boolean matches(@Nullable Entity entity) {
        for (TestableEntity child : this.children) {
            if (!child.matches(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Entity spawn(@NotNull Location location) {
        return new ArrayList<TestableEntity>(this.children).get(NumberUtils.randInt(0, this.children.size() - 1)).spawn(location);
    }

    public Collection<TestableEntity> getChildren() {
        return new ArrayList<TestableEntity>(this.children);
    }
}

