/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.gui.page;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.gui.GUIComponent;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.menu.MenuBuilder;
import com.willfp.eco.core.gui.page.PageBuilder;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.bukkit.entity.Player;

public final class Page
implements GUIComponent {
    public static final String PAGE_KEY = "page";
    public static final String MAX_PAGE_KEY = "max_page";
    private final int pageNumber;
    private final Menu page;
    private Menu delegate = null;
    private int rows = 6;
    private int columns = 9;

    public Page(int pageNumber, @NotNull Menu page) {
        this.pageNumber = pageNumber;
        this.page = page;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    @Nullable
    public Slot getSlotAt(int row2, int column, @NotNull Player player, @NotNull Menu menu) {
        if (menu.getPage(player) != this.pageNumber) {
            return null;
        }
        if (this.delegate == null) {
            this.delegate = Eco.get().blendMenuState(this.page, menu);
        }
        return this.page.getSlot(row2, column, player);
    }

    @Override
    public void init(int maxRows, int maxColumns) {
        this.rows = maxRows;
        this.columns = maxColumns;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    public static PageBuilder builder(@NotNull MenuBuilder context) {
        return Menu.builder(context.getRows());
    }
}

