/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.gui.slot;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.fast.FastItemStack;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.CustomSlot;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.gui.slot.SlotBuilder;
import com.willfp.eco.core.gui.slot.functional.SlotHandler;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ConfigSlot
extends CustomSlot {
    private final Config config;
    private final Map<String, List<CommandToDispatch>> handlers = new HashMap<String, List<CommandToDispatch>>();

    public ConfigSlot(@NotNull Config config) {
        this.config = config;
        ItemStack item = Items.lookup(config.getString("item")).getItem();
        SlotBuilder builder = Slot.builder((Player player, Menu menu) -> {
            if (!config.has("lore")) {
                return item;
            }
            FastItemStack fast = FastItemStack.wrap(item.clone());
            ArrayList<String> newLore = new ArrayList<String>(fast.getLore());
            newLore.addAll(StringUtils.formatList(config.getStrings("lore"), player, StringUtils.FormatOption.WITH_PLACEHOLDERS));
            fast.setLore(newLore);
            return fast.unwrap();
        });
        for (ClickType clickType : ClickType.values()) {
            builder.onClick(clickType, this.dispatchCommandHandler(clickType.name().toLowerCase(Locale.ROOT).replace("_", "-") + "-click"));
        }
        this.init(builder.build());
    }

    private SlotHandler dispatchCommandHandler(@NotNull String configKey) {
        if (!this.handlers.containsKey(configKey)) {
            ArrayList<CommandToDispatch> commands = new ArrayList<CommandToDispatch>();
            for (String command2 : this.config.getStrings(configKey)) {
                if (command2.startsWith("console:")) {
                    commands.add(new CommandToDispatch(StringUtils.removePrefix(command2, "console:"), true));
                    continue;
                }
                commands.add(new CommandToDispatch(command2, false));
            }
            this.handlers.put(configKey, commands);
        }
        List<CommandToDispatch> toDispatch = this.handlers.get(configKey);
        return (event, slot, menu) -> {
            Player player = (Player)event.getWhoClicked();
            for (CommandToDispatch dispatch : toDispatch) {
                dispatch.dispatch(player);
            }
        };
    }

    private record CommandToDispatch(@NotNull String command, boolean console) {
        void dispatch(@NotNull Player player) {
            if (this.console()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.command().replace("%player%", player.getName()));
            } else {
                Bukkit.dispatchCommand((CommandSender)player, (String)this.command().replace("%player%", player.getName()));
            }
        }
    }
}

