/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.gui.slot;

import com.willfp.eco.core.gui.GUIComponent;
import com.willfp.eco.core.gui.slot.FillerSlot;
import com.willfp.eco.core.gui.slot.MaskItems;
import com.willfp.eco.core.gui.slot.MaskMaterials;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.items.builder.ItemStackBuilder;
import com.willfp.eco.core.recipe.parts.EmptyTestableItem;
import com.willfp.eco.core.recipe.parts.MaterialTestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.ListUtils;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class FillerMask
implements GUIComponent {
    private final List<List<Slot>> mask;
    private final int rows;

    public FillerMask(@NotNull Material material, String ... pattern) {
        this(new MaskItems(new MaterialTestableItem(material)), pattern);
    }

    @Deprecated(since="6.24.0")
    public FillerMask(@NotNull MaskMaterials materials, String ... pattern) {
        this(materials.toMaskItems(), pattern);
    }

    public FillerMask(@NotNull MaskItems items, String ... pattern) {
        if (Arrays.stream(items.items()).anyMatch(item -> item instanceof EmptyTestableItem)) {
            throw new IllegalArgumentException("Items cannot be empty!");
        }
        this.rows = pattern.length;
        this.mask = ListUtils.create2DList(this.rows, 9);
        for (int i = 0; i < items.items().length; ++i) {
            ItemStack itemStack = ((ItemStackBuilder)new ItemStackBuilder(items.items()[i]).setDisplayName("&r")).build();
            int row2 = 0;
            for (String patternRow : pattern) {
                int column = 0;
                for (char c : patternRow.toCharArray()) {
                    if (c == '0') {
                        this.mask.get(row2).set(column, null);
                    } else if (c == Character.forDigit(i + 1, 10)) {
                        this.mask.get(row2).set(column, new FillerSlot(itemStack));
                    }
                    ++column;
                }
                ++row2;
            }
        }
    }

    public List<List<Slot>> getMask() {
        return this.mask;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getColumns() {
        return 9;
    }

    @Override
    @Nullable
    public Slot getSlotAt(int row2, int column) {
        return this.mask.get(row2 - 1).get(column - 1);
    }
}

