/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.gui.slot;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.gui.GUIComponent;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.SlotBuilder;
import com.willfp.eco.core.gui.slot.functional.SlotProvider;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public interface Slot
extends GUIComponent {
    @NotNull
    public ItemStack getItemStack(@NotNull Player var1);

    default public boolean isCaptive(@NotNull Player player, @NotNull Menu menu) {
        return false;
    }

    default public boolean isAllowedCaptive(@NotNull Player player, @NotNull Menu menu, @Nullable ItemStack itemStack) {
        return this.isCaptive(player, menu);
    }

    @NotNull
    default public Slot getActionableSlot(@NotNull Player player, @NotNull Menu menu) {
        return this;
    }

    default public boolean isCaptiveFromEmpty() {
        return false;
    }

    @Deprecated(since="6.66.0", forRemoval=true)
    default public boolean shouldRenderOnClick() {
        return this.shouldRenderOnClick(ClickType.LEFT);
    }

    default public boolean shouldRenderOnClick(@NotNull ClickType clickType) {
        return true;
    }

    @Override
    default public int getRows() {
        return 1;
    }

    @Override
    default public int getColumns() {
        return 1;
    }

    @Override
    default public Slot getSlotAt(int row2, int column) {
        return this;
    }

    public static SlotBuilder builder() {
        return Eco.get().createSlotBuilder((player, menu) -> new ItemStack(Material.AIR));
    }

    public static SlotBuilder builder(@NotNull ItemStack itemStack) {
        return Eco.get().createSlotBuilder((player, menu) -> itemStack);
    }

    public static SlotBuilder builder(@NotNull TestableItem item) {
        return Eco.get().createSlotBuilder((player, menu) -> item.getItem());
    }

    @Deprecated(since="6.45.0", forRemoval=true)
    public static SlotBuilder builder(@NotNull Function<Player, ItemStack> provider) {
        return Eco.get().createSlotBuilder((player, menu) -> (ItemStack)provider.apply(player));
    }

    public static SlotBuilder builder(@NotNull SlotProvider provider) {
        return Eco.get().createSlotBuilder(provider);
    }
}

