/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.integrations.anticheat;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.integrations.IntegrationRegistry;
import com.willfp.eco.core.integrations.anticheat.AnticheatIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public final class AnticheatManager {
    private static final IntegrationRegistry<AnticheatIntegration> REGISTRY = new IntegrationRegistry();

    public static void register(@NotNull AnticheatIntegration anticheat) {
        if (anticheat instanceof Listener) {
            Eco.get().getEcoPlugin().getEventManager().registerListener((Listener)anticheat);
        }
        REGISTRY.register(anticheat);
    }

    public static void exemptPlayer(@NotNull Player player) {
        REGISTRY.forEachSafely(anticheat -> anticheat.exempt(player));
    }

    public static void unexemptPlayer(@NotNull Player player) {
        REGISTRY.forEachSafely(anticheat -> anticheat.unexempt(player));
    }

    private AnticheatManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

