/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.integrations.guidetection;

import com.willfp.eco.core.integrations.IntegrationRegistry;
import com.willfp.eco.core.integrations.guidetection.GUIDetectionIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.MenuUtils;
import org.bukkit.entity.Player;

public final class GUIDetectionManager {
    private static final IntegrationRegistry<GUIDetectionIntegration> REGISTRY = new IntegrationRegistry();

    public static void register(@NotNull GUIDetectionIntegration integration) {
        REGISTRY.register(integration);
    }

    public static boolean hasGUIOpen(@NotNull Player player) {
        if (MenuUtils.getOpenMenu(player) != null) {
            return true;
        }
        return REGISTRY.anySafely(integration -> integration.hasGUIOpen(player));
    }

    private GUIDetectionManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

