/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.items;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.willfp.eco.core.Eco;
import com.willfp.eco.core.fast.FastItemStack;
import com.willfp.eco.core.items.CustomItem;
import com.willfp.eco.core.items.HashedItem;
import com.willfp.eco.core.items.ItemsLookupHandler;
import com.willfp.eco.core.items.TestableItem;
import com.willfp.eco.core.items.args.LookupArgParser;
import com.willfp.eco.core.items.provider.ItemProvider;
import com.willfp.eco.core.recipe.parts.EmptyTestableItem;
import com.willfp.eco.core.recipe.parts.MaterialTestableItem;
import com.willfp.eco.core.recipe.parts.ModifiedTestableItem;
import com.willfp.eco.core.recipe.parts.TestableStack;
import com.willfp.eco.core.recipe.parts.UnrestrictedMaterialTestableItem;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NamespacedKeyUtils;
import com.willfp.eco.util.NumberUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;

public final class Items {
    private static final Map<NamespacedKey, TestableItem> REGISTRY = new ConcurrentHashMap<NamespacedKey, TestableItem>();
    private static final LoadingCache<HashedItem, Optional<TestableItem>> CACHE = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(key -> {
        if (!key.getItem().hasItemMeta()) {
            return Optional.empty();
        }
        TestableItem match = null;
        for (TestableItem item : REGISTRY.values()) {
            if (!item.matches(key.getItem())) continue;
            match = item;
            break;
        }
        return Optional.ofNullable(match);
    });
    private static final Map<String, ItemProvider> PROVIDERS = new ConcurrentHashMap<String, ItemProvider>();
    private static final List<LookupArgParser> ARG_PARSERS = new ArrayList<LookupArgParser>();
    private static final ItemsLookupHandler ITEMS_LOOKUP_HANDLER = new ItemsLookupHandler(Items::doParse);
    private static final TestableItem EMPTY_TESTABLE_ITEM = new EmptyTestableItem();
    private static final Map<String, Material> FRIENDLY_MATERIAL_NAMES = new HashMap<String, Material>();

    public static void registerCustomItem(@NotNull NamespacedKey key, @NotNull TestableItem item) {
        REGISTRY.put(key, item);
    }

    public static void registerItemProvider(@NotNull ItemProvider provider) {
        PROVIDERS.put(provider.getNamespace(), provider);
    }

    public static void registerArgParser(@NotNull LookupArgParser parser) {
        ARG_PARSERS.add(parser);
    }

    public static void removeCustomItem(@NotNull NamespacedKey key) {
        REGISTRY.remove(key);
    }

    @NotNull
    public static String toLookupString(@Nullable ItemStack itemStack) {
        ItemMeta meta;
        if (itemStack == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        CustomItem customItem = Items.getCustomItem(itemStack);
        if (customItem != null) {
            builder.append(customItem.getKey());
        } else {
            builder.append(itemStack.getType().name().toLowerCase());
        }
        if (itemStack.getAmount() > 1) {
            builder.append(" ").append(itemStack.getAmount());
        }
        if ((meta = itemStack.getItemMeta()) != null) {
            for (LookupArgParser parser : ARG_PARSERS) {
                String parsed = parser.serializeBack(meta);
                if (parsed == null) continue;
                builder.append(" ").append(parsed);
            }
        }
        return builder.toString();
    }

    @NotNull
    public static TestableItem lookup(@NotNull String key) {
        if (key.startsWith("{")) {
            return Eco.get().testableItemFromSNBT(key);
        }
        return (TestableItem)ITEMS_LOOKUP_HANDLER.parseKey(key);
    }

    @NotNull
    private static TestableItem doParse(@NotNull String[] args2) {
        if (args2.length == 0) {
            return new EmptyTestableItem();
        }
        TestableItem item = null;
        int stackAmount = 1;
        String[] split = args2[0].toLowerCase().split(":");
        if (split.length == 1) {
            Material material;
            String itemType = args2[0];
            boolean isWildcard = itemType.startsWith("*");
            if (isWildcard) {
                itemType = itemType.substring(1);
            }
            if ((material = FRIENDLY_MATERIAL_NAMES.get(itemType.toLowerCase())) == null || material == Material.AIR) {
                return new EmptyTestableItem();
            }
            TestableItem testableItem = item = isWildcard ? new UnrestrictedMaterialTestableItem(material) : new MaterialTestableItem(material);
        }
        if (split.length == 2) {
            String namespace = split[0];
            String keyID = split[1];
            NamespacedKey namespacedKey = NamespacedKeyUtils.create(namespace, keyID);
            TestableItem part = REGISTRY.get(namespacedKey);
            if (part == null && PROVIDERS.containsKey(namespace)) {
                String reformattedKey;
                ItemProvider provider = PROVIDERS.get(namespace);
                part = provider.provideForKey(reformattedKey = keyID.replace("__", ":"));
                if (part instanceof EmptyTestableItem || part == null) {
                    return new EmptyTestableItem();
                }
                Items.registerCustomItem(namespacedKey, part);
            }
            if (part == null) {
                Material material;
                String itemType = split[0];
                boolean isWildcard = itemType.startsWith("*");
                if (isWildcard) {
                    itemType = itemType.substring(1);
                }
                if ((material = Material.getMaterial((String)itemType.toUpperCase())) == null || material == Material.AIR) {
                    return new EmptyTestableItem();
                }
                item = isWildcard ? new UnrestrictedMaterialTestableItem(material) : new MaterialTestableItem(material);
                stackAmount = Integer.parseInt(split[1]);
            } else {
                item = part;
            }
        }
        if (split.length == 3) {
            TestableItem part = REGISTRY.get(NamespacedKeyUtils.create(split[0], split[1]));
            if (part == null) {
                return new EmptyTestableItem();
            }
            item = part;
            stackAmount = Integer.parseInt(split[2]);
        }
        boolean usingNewStackFormat = false;
        if (args2.length >= 2) {
            try {
                stackAmount = Integer.parseInt(args2[1]);
                usingNewStackFormat = true;
            }
            catch (NumberFormatException keyID) {
                // empty catch block
            }
        }
        if (item == null || item instanceof EmptyTestableItem) {
            return new EmptyTestableItem();
        }
        ItemStack example = item.getItem();
        ItemMeta meta = example.getItemMeta();
        assert (meta != null);
        String[] modifierArgs = Arrays.copyOfRange(args2, usingNewStackFormat ? 2 : 1, args2.length);
        ArrayList<Predicate<ItemStack>> predicates = new ArrayList<Predicate<ItemStack>>();
        for (LookupArgParser argParser : ARG_PARSERS) {
            Predicate<ItemStack> predicate2 = argParser.parseArguments(modifierArgs, meta);
            if (predicate2 == null) continue;
            predicates.add(argParser.parseArguments(modifierArgs, meta));
        }
        example.setItemMeta(meta);
        if (!predicates.isEmpty()) {
            item = new ModifiedTestableItem(item, test -> {
                for (Predicate predicate2 : predicates) {
                    if (predicate2.test(test)) continue;
                    return false;
                }
                return true;
            }, example);
        }
        if (stackAmount <= 1) {
            return item;
        }
        return new TestableStack(item, stackAmount);
    }

    @NotNull
    public static TestableItem getItem(@Nullable ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return new EmptyTestableItem();
        }
        CustomItem customItem = Items.getCustomItem(item);
        if (customItem != null) {
            return customItem;
        }
        for (TestableItem known : REGISTRY.values()) {
            if (!known.matches(item)) continue;
            return known;
        }
        return new MaterialTestableItem(item.getType());
    }

    public static boolean isCustomItem(@Nullable ItemStack itemStack) {
        return Items.getCustomItem(itemStack) != null;
    }

    @Nullable
    public static CustomItem getCustomItem(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return CACHE.get(HashedItem.of(itemStack)).map(Items::getOrWrap).orElse(null);
    }

    public static Set<CustomItem> getCustomItems() {
        return REGISTRY.values().stream().map(Items::getOrWrap).collect(Collectors.toSet());
    }

    @NotNull
    public static CustomItem getOrWrap(@NotNull TestableItem item) {
        if (item instanceof CustomItem) {
            return (CustomItem)item;
        }
        return new CustomItem(NamespacedKeyUtils.createEcoKey("wrapped_" + NumberUtils.randInt(0, 100000)), item::matches, item.getItem());
    }

    @NotNull
    public static TestableItem[] fromMaterials(Material ... materials) {
        return (TestableItem[])Arrays.stream(materials).map(MaterialTestableItem::new).toArray(MaterialTestableItem[]::new);
    }

    @NotNull
    public static Collection<TestableItem> fromMaterials(@NotNull Iterable<Material> materials) {
        ArrayList<TestableItem> items = new ArrayList<TestableItem>();
        for (Material material : materials) {
            items.add(new MaterialTestableItem(material));
        }
        return items;
    }

    @NotNull
    public static ItemStack mergeFrom(@NotNull ItemStack from, @NotNull ItemStack to) {
        ItemMeta fromMeta = from.getItemMeta();
        ItemMeta toMeta = to.getItemMeta();
        if (fromMeta == null || toMeta == null) {
            return to;
        }
        ItemMeta newMeta = Items.mergeFrom(fromMeta, toMeta);
        to.setItemMeta(newMeta);
        to.setType(from.getType());
        to.setAmount(from.getAmount());
        return to;
    }

    @NotNull
    public static ItemMeta mergeFrom(@NotNull ItemMeta from, @NotNull ItemMeta to) {
        if (from.hasDisplayName()) {
            to.setDisplayName(from.getDisplayName());
        }
        to.setLore(from.getLore());
        for (Enchantment enchantment : to.getEnchants().keySet()) {
            to.removeEnchant(enchantment);
        }
        for (Map.Entry entry : from.getEnchants().entrySet()) {
            to.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
        }
        if (from.hasCustomModelData()) {
            to.setCustomModelData(Integer.valueOf(from.getCustomModelData()));
        } else {
            to.setCustomModelData(null);
        }
        return to;
    }

    @NotNull
    public static PersistentDataContainer getBaseNBT(@NotNull ItemStack itemStack) {
        return FastItemStack.wrap(itemStack).getBaseTag();
    }

    @NotNull
    public static ItemStack setBaseNBT(@NotNull ItemStack itemStack, @Nullable PersistentDataContainer container) {
        FastItemStack fis = FastItemStack.wrap(itemStack);
        fis.setBaseTag(container);
        return fis.unwrap();
    }

    @NotNull
    public static String toSNBT(@NotNull ItemStack itemStack) {
        return Eco.get().toSNBT(itemStack);
    }

    @Nullable
    public static ItemStack fromSNBT(@NotNull String snbt) {
        return Eco.get().fromSNBT(snbt);
    }

    public static boolean isEmpty(@Nullable ItemStack itemStack) {
        return EMPTY_TESTABLE_ITEM.matches(itemStack);
    }

    public static boolean matchesAny(@Nullable ItemStack itemStack, @NotNull Collection<TestableItem> items) {
        for (TestableItem item : items) {
            if (!item.matches(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesAny(@NotNull Collection<ItemStack> itemStacks, @NotNull Collection<TestableItem> items) {
        for (ItemStack itemStack : itemStacks) {
            if (!Items.matchesAny(itemStack, items)) continue;
            return true;
        }
        return false;
    }

    private Items() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (Material material : Material.values()) {
            String oneWordPlural;
            String plural;
            FRIENDLY_MATERIAL_NAMES.put(material.name().toLowerCase(), material);
            String oneWord = material.name().toLowerCase().replace("_", "");
            if (!FRIENDLY_MATERIAL_NAMES.containsKey(oneWord)) {
                FRIENDLY_MATERIAL_NAMES.put(oneWord, material);
            }
            if (!FRIENDLY_MATERIAL_NAMES.containsKey(plural = material.name().toLowerCase() + "s")) {
                FRIENDLY_MATERIAL_NAMES.put(plural, material);
            }
            if (FRIENDLY_MATERIAL_NAMES.containsKey(oneWordPlural = oneWord + "s")) continue;
            FRIENDLY_MATERIAL_NAMES.put(oneWordPlural, material);
        }
    }
}

