/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.placeholder;

import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.PatternUtils;
import com.willfp.eco.util.StringUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

public final class PlayerStaticPlaceholder
implements InjectablePlaceholder {
    private final String identifier;
    private final Pattern pattern;
    private final Function<@NotNull Player, @Nullable String> function;

    public PlayerStaticPlaceholder(@NotNull String identifier, @NotNull @NotNull Function<@NotNull Player, @Nullable String> function) {
        this.identifier = "%" + identifier + "%";
        this.pattern = PatternUtils.compileLiteral(identifier);
        this.function = function;
    }

    @Override
    @Nullable
    public String getValue(@NotNull String args2, @NotNull PlaceholderContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return null;
        }
        return this.getValue(player);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    @NotNull
    public String getValue(@NotNull Player player) {
        return Objects.requireNonNullElse(this.function.apply(player), "");
    }

    @Override
    public String tryTranslateQuickly(@NotNull String text, @NotNull PlaceholderContext context) {
        return StringUtils.replaceQuickly(text, this.identifier, Objects.requireNonNullElse(this.getValue(this.identifier, context), ""));
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerStaticPlaceholder)) {
            return false;
        }
        PlayerStaticPlaceholder that = (PlayerStaticPlaceholder)o;
        return Objects.equals(this.getPattern(), that.getPattern());
    }

    public int hashCode() {
        return Objects.hash(this.getPattern());
    }
}

