/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.placeholder.templates;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.placeholder.RegistrablePlaceholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.PatternUtils;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class SimplePlaceholder
implements RegistrablePlaceholder {
    private final EcoPlugin plugin;
    private final String identifier;
    private final Pattern pattern;

    protected SimplePlaceholder(@NotNull EcoPlugin plugin, @NotNull String identifier) {
        this.plugin = plugin;
        this.identifier = identifier;
        this.pattern = PatternUtils.compileLiteral(identifier);
    }

    @Override
    public String tryTranslateQuickly(@NotNull String text, @NotNull PlaceholderContext context) {
        return text.replace("%" + this.identifier + "%", Objects.requireNonNullElse(this.getValue(this.identifier, context), ""));
    }

    @Override
    @NotNull
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public EcoPlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return "SimplePlaceholder{plugin='" + this.plugin + "'identifier='" + this.identifier + "'}";
    }

    public boolean equals(@NotNull Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimplePlaceholder)) {
            return false;
        }
        SimplePlaceholder that = (SimplePlaceholder)o;
        return Objects.equals(this.pattern, that.getPattern()) && Objects.equals(this.plugin, that.getPlugin());
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.plugin);
    }
}

