/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.price.impl;

import com.willfp.eco.core.integrations.economy.EconomyManager;
import com.willfp.eco.core.math.MathContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContextSupplier;
import com.willfp.eco.core.price.Price;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class PriceEconomy
implements Price {
    private final PlaceholderContextSupplier<Double> function;
    private final PlaceholderContext baseContext;
    private final Map<UUID, Double> multipliers = new HashMap<UUID, Double>();

    public PriceEconomy(double value) {
        this(PlaceholderContext.EMPTY, (PlaceholderContext ctx) -> value);
    }

    @Deprecated(since="6.56.0", forRemoval=true)
    public PriceEconomy(@NotNull MathContext baseContext, @NotNull Function<MathContext, Double> function) {
        this(baseContext.toPlaceholderContext(), (PlaceholderContext ctx) -> (Double)function.apply(ctx.toMathContext()));
    }

    public PriceEconomy(@NotNull PlaceholderContext baseContext, @NotNull PlaceholderContextSupplier<Double> function) {
        this.baseContext = baseContext;
        this.function = function;
    }

    @Override
    public boolean canAfford(@NotNull Player player, double multiplier) {
        return EconomyManager.getBalance((OfflinePlayer)player) >= this.getValue(player, multiplier);
    }

    @Override
    public void pay(@NotNull Player player, double multiplier) {
        EconomyManager.removeMoney((OfflinePlayer)player, this.getValue(player, multiplier));
    }

    @Override
    public void giveTo(@NotNull Player player, double multiplier) {
        EconomyManager.giveMoney((OfflinePlayer)player, this.getValue(player, multiplier));
    }

    @Override
    public double getValue(@NotNull Player player, double multiplier) {
        return this.function.get(this.baseContext.copyWithPlayer(player)) * this.getMultiplier(player) * multiplier;
    }

    @Override
    public double getMultiplier(@NotNull Player player) {
        return this.multipliers.getOrDefault(player.getUniqueId(), 1.0);
    }

    @Override
    public void setMultiplier(@NotNull Player player, double multiplier) {
        this.multipliers.put(player.getUniqueId(), multiplier);
    }

    @Override
    public String getIdentifier() {
        return "eco:economy";
    }
}

