/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.recipe;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.items.Items;
import com.willfp.eco.core.recipe.recipes.CraftingRecipe;
import com.willfp.eco.core.recipe.recipes.ShapedCraftingRecipe;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NamespacedKeyUtils;
import java.util.List;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;

public final class Recipes {
    private static final BiMap<NamespacedKey, CraftingRecipe> RECIPES = HashBiMap.create();
    private static final LoadingCache<ItemStack[], Optional<CraftingRecipe>> RECIPES_FROM_MATRIX = Caffeine.newBuilder().maximumSize(2048L).build(matrix -> RECIPES.values().stream().filter(recipe -> recipe.test((ItemStack[])matrix)).findFirst());

    public static void register(@NotNull CraftingRecipe recipe) {
        RECIPES.forcePut((Object)recipe.getKey(), (Object)recipe);
        RECIPES_FROM_MATRIX.invalidateAll();
    }

    @Nullable
    public static CraftingRecipe getMatch(@Nullable ItemStack[] matrix) {
        if (matrix == null) {
            return null;
        }
        return RECIPES_FROM_MATRIX.get(matrix).orElse(null);
    }

    @Nullable
    public static CraftingRecipe getRecipe(@NotNull NamespacedKey key) {
        CraftingRecipe recipe = (CraftingRecipe)RECIPES.get((Object)key);
        if (recipe != null) {
            return recipe;
        }
        if (key.getKey().contains("_displayed")) {
            NamespacedKey otherKey = NamespacedKeyUtils.create(key.getNamespace(), key.getKey().replace("_displayed", ""));
            return (CraftingRecipe)RECIPES.get((Object)otherKey);
        }
        return null;
    }

    public static CraftingRecipe createAndRegisterRecipe(@NotNull EcoPlugin plugin, @NotNull String key, @NotNull ItemStack output, @NotNull List<String> recipeStrings) {
        return Recipes.createAndRegisterRecipe(plugin, key, output, recipeStrings, null);
    }

    @Nullable
    public static CraftingRecipe createAndRegisterRecipe(@NotNull EcoPlugin plugin, @NotNull String key, @NotNull ItemStack output, @NotNull List<String> recipeStrings, @Nullable String permission) {
        ShapedCraftingRecipe.Builder builder = ShapedCraftingRecipe.builder(plugin, key).setOutput(output).setPermission(permission);
        for (int i = 0; i < 9; ++i) {
            builder.setRecipePart(i, Items.lookup(recipeStrings.get(i)));
        }
        if (builder.isAir()) {
            plugin.getLogger().warning("Crafting recipe " + plugin.getID() + ":" + key + " consists only");
            plugin.getLogger().warning("of air or invalid items! It will not be registered.");
            return null;
        }
        ShapedCraftingRecipe recipe = builder.build();
        recipe.register();
        return recipe;
    }

    private Recipes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

