/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.PluginProps;
import com.willfp.eco.core.config.ConfigExtensions;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0016\u0010\t\u001a\u00020\u00072\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bJ\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/willfp/eco/internal/EcoPropsParser;", "Lcom/willfp/eco/core/PluginProps$PropsParser;", "Lcom/willfp/eco/core/config/interfaces/Config;", "()V", "parseAndApplyOptions", "", "props", "Lcom/willfp/eco/core/PluginProps;", "config", "parseForPlugin", "plugin", "Ljava/lang/Class;", "Lcom/willfp/eco/core/EcoPlugin;", "parseFrom", "core-backend"})
public final class EcoPropsParser
implements PluginProps.PropsParser<Config> {
    @NotNull
    public static final EcoPropsParser INSTANCE = new EcoPropsParser();

    private EcoPropsParser() {
    }

    @Override
    @NotNull
    public PluginProps parseFrom(@NotNull Config config) {
        PluginProps pluginProps;
        Intrinsics.checkNotNullParameter(config, "config");
        PluginProps props = this.getBlankProps();
        if (!config.has("options")) {
            Intrinsics.checkNotNull(props);
            this.parseAndApplyOptions(props, config);
        } else {
            Intrinsics.checkNotNull(props);
            Config config2 = config.getSubsection("options");
            Intrinsics.checkNotNullExpressionValue(config2, "getSubsection(...)");
            this.parseAndApplyOptions(props, config2);
        }
        PluginProps $this$parseFrom_u24lambda_u240 = pluginProps = props;
        boolean bl = false;
        for (Config config3 : config.getSubsections("environment")) {
            String string;
            String string2;
            if (config3.getStringOrNull("name") == null) continue;
            Intrinsics.checkNotNull(string2);
            String name = string2;
            if (config3.getStringOrNull("value") == null) continue;
            Intrinsics.checkNotNull(string);
            String value = string;
            $this$parseFrom_u24lambda_u240.setEnvironmentVariable(name, value);
        }
        return pluginProps;
    }

    private final void parseAndApplyOptions(PluginProps props, Config config) {
        PluginProps pluginProps;
        Boolean bl;
        String color;
        String string;
        String proxyPackage;
        Integer n = config.getIntOrNull("resource-id");
        if (n == null) {
            n = 0;
        }
        int resourceId = ((Number)n).intValue();
        Integer n2 = config.getIntOrNull("bstats-id");
        if (n2 == null) {
            n2 = 0;
        }
        int bStatsId = ((Number)n2).intValue();
        String string2 = config.getStringOrNull("proxy-package");
        if (string2 == null) {
            string2 = proxyPackage = "";
        }
        if ((string = config.getStringOrNull("color")) == null) {
            string = color = "&f";
        }
        if ((bl = config.getBoolOrNull("supports-extensions")) == null) {
            bl = false;
        }
        boolean supportsExtensions = bl;
        Boolean bl2 = config.getBoolOrNull("uses-reflective-reload");
        if (bl2 == null) {
            bl2 = true;
        }
        boolean usesReflectiveReload = bl2;
        PluginProps $this$parseAndApplyOptions_u24lambda_u241 = pluginProps = props;
        boolean bl3 = false;
        $this$parseAndApplyOptions_u24lambda_u241.setResourceId(resourceId);
        $this$parseAndApplyOptions_u24lambda_u241.setBStatsId(bStatsId);
        $this$parseAndApplyOptions_u24lambda_u241.setProxyPackage(proxyPackage);
        $this$parseAndApplyOptions_u24lambda_u241.setColor(color);
        $this$parseAndApplyOptions_u24lambda_u241.setSupportingExtensions(supportsExtensions);
        $this$parseAndApplyOptions_u24lambda_u241.setUsesReflectiveReload(usesReflectiveReload);
    }

    @NotNull
    public final PluginProps parseForPlugin(@NotNull Class<? extends EcoPlugin> plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        if (!PluginProps.hasParserFor(Config.class)) {
            PluginProps.registerParser(Config.class, this);
        }
        PluginProps pluginProps = PluginProps.parse(ConfigExtensions.readConfig(plugin.getResourceAsStream("/eco.yml")), Config.class);
        Intrinsics.checkNotNullExpressionValue(pluginProps, "parse(...)");
        return pluginProps;
    }
}

