/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/willfp/eco/internal/config/EcoGsonSerializer;", "Lcom/google/gson/JsonSerializer;", "Lcom/willfp/eco/core/config/interfaces/Config;", "()V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "core-backend"})
public final class EcoGsonSerializer
implements JsonSerializer<Config> {
    @NotNull
    public static final EcoGsonSerializer INSTANCE = new EcoGsonSerializer();
    @NotNull
    private static final Gson gson;

    private EcoGsonSerializer() {
    }

    @NotNull
    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public JsonElement serialize(@NotNull Config src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(typeOfSrc, "typeOfSrc");
        Intrinsics.checkNotNullParameter(context, "context");
        JsonElement jsonElement = gson.toJsonTree(src.toMap());
        Intrinsics.checkNotNullExpressionValue(jsonElement, "toJsonTree(...)");
        return jsonElement;
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter((Type)((Object)Config.class), (Object)INSTANCE).create();
        Intrinsics.checkNotNull(gson);
        EcoGsonSerializer.gson = gson;
    }
}

