/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.config;

import com.willfp.eco.core.PluginLike;
import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.internal.config.ConfigUtilsKt;
import com.willfp.eco.internal.config.EcoConfigSection;
import com.willfp.eco.internal.config.EcoLoadableConfig;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000f\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\u0018\u001a\u00020\u0017R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/willfp/eco/internal/config/EcoUpdatableConfig;", "Lcom/willfp/eco/internal/config/EcoLoadableConfig;", "type", "Lcom/willfp/eco/core/config/ConfigType;", "configName", "", "plugin", "Lcom/willfp/eco/core/PluginLike;", "subDirectoryPath", "source", "Ljava/lang/Class;", "removeUnused", "", "requiresChangesToSave", "updateBlacklist", "", "(Lcom/willfp/eco/core/config/ConfigType;Ljava/lang/String;Lcom/willfp/eco/core/PluginLike;Ljava/lang/String;Ljava/lang/Class;ZZ[Ljava/lang/String;)V", "configInJar", "Lcom/willfp/eco/core/config/interfaces/Config;", "getConfigInJar", "()Lcom/willfp/eco/core/config/interfaces/Config;", "", "postInit", "", "update", "core-backend"})
@SourceDebugExtension(value={"SMAP\nEcoUpdatableConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoUpdatableConfig.kt\ncom/willfp/eco/internal/config/EcoUpdatableConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1855#2,2:68\n1855#2,2:70\n*S KotlinDebug\n*F\n+ 1 EcoUpdatableConfig.kt\ncom/willfp/eco/internal/config/EcoUpdatableConfig\n*L\n28#1:68,2\n36#1:70,2\n*E\n"})
public class EcoUpdatableConfig
extends EcoLoadableConfig {
    private final boolean removeUnused;
    @NotNull
    private final List<String> updateBlacklist;

    public EcoUpdatableConfig(@NotNull ConfigType type2, @NotNull String configName, @NotNull PluginLike plugin, @NotNull String subDirectoryPath, @NotNull Class<?> source, boolean removeUnused, boolean requiresChangesToSave, String ... updateBlacklist) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(configName, "configName");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(subDirectoryPath, "subDirectoryPath");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(updateBlacklist, "updateBlacklist");
        super(type2, configName, plugin, subDirectoryPath, source, requiresChangesToSave);
        this.removeUnused = removeUnused;
        this.updateBlacklist = CollectionsKt.mutableListOf(Arrays.copyOf(updateBlacklist, updateBlacklist.length));
        this.updateBlacklist.removeIf(arg_0 -> EcoUpdatableConfig._init_$lambda$4(1.INSTANCE, arg_0));
        this.postInit(plugin);
    }

    public final void update() {
        this.init(this.getConfigFile());
        Config config = this.getConfigInJar();
        if (config == null) {
            return;
        }
        Config newConfig = config;
        if (Intrinsics.areEqual(newConfig.getKeys(true), this.getKeys(true))) {
            return;
        }
        List<String> list = newConfig.getKeys(true);
        Intrinsics.checkNotNullExpressionValue(list, "getKeys(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            if (this.getKeys(true).contains(key) || !this.updateBlacklist.stream().noneMatch(arg_0 -> EcoUpdatableConfig.update$lambda$1$lambda$0(new Function1<String, Boolean>(key){
                final /* synthetic */ String $key;
                {
                    this.$key = $key;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String s2) {
                    Intrinsics.checkNotNullParameter(s2, "s");
                    return StringsKt.contains$default((CharSequence)this.$key, s2, false, 2, null);
                }
            }, arg_0))) continue;
            this.set(key, newConfig.get(key));
        }
        if (this.removeUnused) {
            $this$forEach$iv = this.getKeys(true);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String s2 = (String)element$iv;
                boolean bl = false;
                if (newConfig.getKeys(true).contains(s2) || !this.updateBlacklist.stream().noneMatch(arg_0 -> EcoUpdatableConfig.update$lambda$3$lambda$2(new Function1<CharSequence, Boolean>((Object)s2){

                    @NotNull
                    public final Boolean invoke(@NotNull CharSequence p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        return StringsKt.contains$default((CharSequence)((String)this.receiver), p0, false, 2, null);
                    }
                }, arg_0))) continue;
                this.set(s2, null);
            }
        }
        this.save();
    }

    private final Config getConfigInJar() {
        InputStream inputStream = this.getSource().getResourceAsStream(this.getResourcePath());
        if (inputStream == null) {
            return null;
        }
        InputStream newIn = inputStream;
        BufferedReader reader = new BufferedReader(new InputStreamReader(newIn, StandardCharsets.UTF_8));
        EcoConfigSection config = new EcoConfigSection(this.getType(), MapsKt.emptyMap(), null, 4, null);
        config.init(ConfigUtilsKt.toMap(this.getType(), ConfigUtilsKt.readToString(reader)), MapsKt.emptyMap());
        return config;
    }

    private final void postInit(PluginLike plugin) {
        plugin.getConfigHandler().addConfig(this);
        this.update();
    }

    private static final boolean update$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean update$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

