/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.events;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.events.EventManager;
import com.willfp.eco.core.map.MutableListMap;
import com.willfp.eco.core.packet.PacketListener;
import com.willfp.eco.core.packet.PacketPriority;
import com.willfp.eco.internal.events.EcoEventManagerKt;
import com.willfp.eco.internal.events.RegisteredPacketListener;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/willfp/eco/internal/events/EcoEventManager;", "Lcom/willfp/eco/core/events/EventManager;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "registerListener", "", "listener", "Lorg/bukkit/event/Listener;", "registerPacketListener", "Lcom/willfp/eco/core/packet/PacketListener;", "unregisterAllListeners", "unregisterListener", "core-backend"})
public final class EcoEventManager
implements EventManager {
    @NotNull
    private final EcoPlugin plugin;

    public EcoEventManager(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @Override
    public void registerListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.plugin);
    }

    @Override
    public void unregisterListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        HandlerList.unregisterAll((Listener)listener);
    }

    @Override
    public void unregisterAllListeners() {
        HandlerList.unregisterAll((Plugin)((Plugin)this.plugin));
        for (List value : EcoEventManagerKt.access$getListeners$p().values()) {
            value.removeIf(arg_0 -> EcoEventManager.unregisterAllListeners$lambda$0(new Function1<RegisteredPacketListener, Boolean>(this){
                final /* synthetic */ EcoEventManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(RegisteredPacketListener it) {
                    return Intrinsics.areEqual(it.getPlugin(), EcoEventManager.access$getPlugin$p(this.this$0));
                }
            }, arg_0));
        }
    }

    @Override
    public void registerPacketListener(@NotNull PacketListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        MutableListMap mutableListMap = EcoEventManagerKt.access$getListeners$p();
        PacketPriority packetPriority = listener.getPriority();
        ((Collection)mutableListMap.get((Object)packetPriority)).add(new RegisteredPacketListener(this.plugin, listener));
    }

    private static final boolean unregisterAllListeners$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ EcoPlugin access$getPlugin$p(EcoEventManager $this) {
        return $this.plugin;
    }
}

