/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.gui.slot;

import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.gui.slot.functional.SlotHandler;
import com.willfp.eco.core.gui.slot.functional.SlotProvider;
import com.willfp.eco.core.gui.slot.functional.SlotUpdater;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.MenuUtilsExtensions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J*\u0010\u001a\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/willfp/eco/internal/gui/slot/EcoSlot;", "Lcom/willfp/eco/core/gui/slot/Slot;", "provider", "Lcom/willfp/eco/core/gui/slot/functional/SlotProvider;", "handlers", "", "Lorg/bukkit/event/inventory/ClickType;", "", "Lcom/willfp/eco/core/gui/slot/functional/SlotHandler;", "updater", "Lcom/willfp/eco/core/gui/slot/functional/SlotUpdater;", "(Lcom/willfp/eco/core/gui/slot/functional/SlotProvider;Ljava/util/Map;Lcom/willfp/eco/core/gui/slot/functional/SlotUpdater;)V", "getActionableSlot", "player", "Lorg/bukkit/entity/Player;", "menu", "Lcom/willfp/eco/core/gui/menu/Menu;", "getItemStack", "Lorg/bukkit/inventory/ItemStack;", "handleInventoryClick", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "shouldRenderOnClick", "", "clickType", "handle", "slot", "core-backend"})
@SourceDebugExtension(value={"SMAP\nEcoSlot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoSlot.kt\ncom/willfp/eco/internal/gui/slot/EcoSlot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1855#2,2:41\n*S KotlinDebug\n*F\n+ 1 EcoSlot.kt\ncom/willfp/eco/internal/gui/slot/EcoSlot\n*L\n21#1:41,2\n*E\n"})
public class EcoSlot
implements Slot {
    @NotNull
    private final SlotProvider provider;
    @NotNull
    private final Map<ClickType, List<SlotHandler>> handlers;
    @NotNull
    private final SlotUpdater updater;

    public EcoSlot(@NotNull SlotProvider provider, @NotNull Map<ClickType, ? extends List<? extends SlotHandler>> handlers, @NotNull SlotUpdater updater) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        Intrinsics.checkNotNullParameter(handlers, "handlers");
        Intrinsics.checkNotNullParameter(updater, "updater");
        this.provider = provider;
        this.handlers = handlers;
        this.updater = updater;
    }

    private final void handle(List<? extends SlotHandler> $this$handle, InventoryClickEvent event, Slot slot, Menu menu) {
        Iterable $this$forEach$iv = $this$handle;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SlotHandler it = (SlotHandler)element$iv;
            boolean bl = false;
            it.handle(event, slot, menu);
        }
    }

    public final void handleInventoryClick(@NotNull InventoryClickEvent event, @NotNull Menu menu) {
        block0: {
            Intrinsics.checkNotNullParameter(event, "event");
            Intrinsics.checkNotNullParameter(menu, "menu");
            List<SlotHandler> list = this.handlers.get(event.getClick());
            if (list == null) break block0;
            this.handle(list, event, this, menu);
        }
    }

    @Override
    @NotNull
    public ItemStack getItemStack(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Menu menu = MenuUtilsExtensions.getOpenMenu(player);
        if (menu == null) {
            return new ItemStack(Material.AIR);
        }
        Menu menu2 = menu;
        ItemStack itemStack = this.provider.provide(player, menu2);
        if (itemStack == null) {
            return new ItemStack(Material.AIR);
        }
        ItemStack base = itemStack;
        ItemStack itemStack2 = this.updater.update(player, menu2, base);
        if (itemStack2 == null) {
            return new ItemStack(Material.AIR);
        }
        return itemStack2;
    }

    @Override
    @NotNull
    public EcoSlot getActionableSlot(@NotNull Player player, @NotNull Menu menu) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(menu, "menu");
        return this;
    }

    @Override
    public boolean shouldRenderOnClick(@NotNull ClickType clickType) {
        Intrinsics.checkNotNullParameter(clickType, "clickType");
        Collection collection = this.handlers.get(clickType);
        return !(collection == null || collection.isEmpty());
    }
}

