/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.gui.slot;

import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.core.gui.slot.SlotBuilder;
import com.willfp.eco.core.gui.slot.functional.CaptiveFilter;
import com.willfp.eco.core.gui.slot.functional.SlotHandler;
import com.willfp.eco.core.gui.slot.functional.SlotProvider;
import com.willfp.eco.core.gui.slot.functional.SlotUpdater;
import com.willfp.eco.core.map.DefaultMapExtensions;
import com.willfp.eco.core.map.MutableListMap;
import com.willfp.eco.internal.gui.slot.EcoCaptiveSlot;
import com.willfp.eco.internal.gui.slot.EcoSlot;
import com.willfp.eco.internal.gui.slot.EcoSlotBuilder;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u000e\u001a\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/willfp/eco/internal/gui/slot/EcoSlotBuilder;", "Lcom/willfp/eco/core/gui/slot/SlotBuilder;", "provider", "Lcom/willfp/eco/core/gui/slot/functional/SlotProvider;", "(Lcom/willfp/eco/core/gui/slot/functional/SlotProvider;)V", "captive", "", "captiveFilter", "Lcom/willfp/eco/core/gui/slot/functional/CaptiveFilter;", "captiveFromEmpty", "handlers", "Lcom/willfp/eco/core/map/MutableListMap;", "Lorg/bukkit/event/inventory/ClickType;", "Lcom/willfp/eco/core/gui/slot/functional/SlotHandler;", "notCaptiveFor", "Lkotlin/Function1;", "Lorg/bukkit/entity/Player;", "updater", "Lcom/willfp/eco/core/gui/slot/functional/SlotUpdater;", "build", "Lcom/willfp/eco/core/gui/slot/Slot;", "predicate", "Ljava/util/function/Predicate;", "onClick", "type", "action", "setCaptive", "fromEmpty", "setCaptiveFilter", "filter", "setUpdater", "core-backend"})
public final class EcoSlotBuilder
implements SlotBuilder {
    @NotNull
    private final SlotProvider provider;
    private boolean captive;
    private boolean captiveFromEmpty;
    @NotNull
    private SlotUpdater updater;
    @NotNull
    private final MutableListMap<ClickType, SlotHandler> handlers;
    @NotNull
    private CaptiveFilter captiveFilter;
    @NotNull
    private Function1<? super Player, Boolean> notCaptiveFor;

    public EcoSlotBuilder(@NotNull SlotProvider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        this.provider = provider;
        this.updater = (arg_0, arg_1, arg_2) -> EcoSlotBuilder.updater$lambda$0(this, arg_0, arg_1, arg_2);
        this.handlers = DefaultMapExtensions.listMap();
        this.captiveFilter = EcoSlotBuilder::captiveFilter$lambda$1;
        this.notCaptiveFor = notCaptiveFor.1.INSTANCE;
    }

    @Override
    @NotNull
    public SlotBuilder onClick(@NotNull ClickType type2, @NotNull SlotHandler action) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(action, "action");
        ((Collection)this.handlers.get((Object)type2)).add(action);
        return this;
    }

    @Override
    @NotNull
    public SlotBuilder notCaptiveFor(@NotNull Predicate<Player> predicate2) {
        Intrinsics.checkNotNullParameter(predicate2, "predicate");
        this.notCaptiveFor = new Function1<Player, Boolean>(predicate2){
            final /* synthetic */ Predicate<Player> $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Player player) {
                Intrinsics.checkNotNullParameter(player, "player");
                return this.$predicate.test(player);
            }
        };
        return this;
    }

    @Override
    @NotNull
    public SlotBuilder setCaptiveFilter(@NotNull CaptiveFilter filter2) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        this.captiveFilter = filter2;
        return this;
    }

    @Override
    @NotNull
    public SlotBuilder setCaptive(boolean fromEmpty) {
        this.captive = true;
        this.captiveFromEmpty = fromEmpty;
        return this;
    }

    @Override
    @NotNull
    public SlotBuilder setUpdater(@NotNull SlotUpdater updater) {
        Intrinsics.checkNotNullParameter(updater, "updater");
        this.updater = updater;
        return this;
    }

    @Override
    @NotNull
    public Slot build() {
        return this.captive ? (Slot)new EcoCaptiveSlot(this.provider, this.captiveFromEmpty, this.notCaptiveFor, this.captiveFilter) : (Slot)new EcoSlot(this.provider, (Map<ClickType, ? extends List<? extends SlotHandler>>)this.handlers, this.updater);
    }

    private static final ItemStack updater$lambda$0(EcoSlotBuilder this$0, Player player, Menu menu, ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(menu, "menu");
        Intrinsics.checkNotNullParameter(itemStack, "<anonymous parameter 2>");
        return this$0.provider.provide(player, menu);
    }

    private static final boolean captiveFilter$lambda$1(Player player, Menu menu, ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(player, "<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter(menu, "<anonymous parameter 1>");
        return true;
    }
}

