/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.placeholder;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.integrations.placeholder.PlaceholderIntegration;
import com.willfp.eco.core.integrations.placeholder.PlaceholderManager;
import com.willfp.eco.core.placeholder.AdditionalPlayer;
import com.willfp.eco.core.placeholder.InjectablePlaceholder;
import com.willfp.eco.core.placeholder.Placeholder;
import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.internal.placeholder.PlaceholderLookup;
import com.willfp.eco.internal.placeholder.PlaceholderParser;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NumberUtilsExtensions;
import com.willfp.eco.util.StringUtils;
import com.willfp.eco.util.StringUtilsExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J(\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J0\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/willfp/eco/internal/placeholder/PlaceholderParser;", "", "()V", "mathExpressionRegex", "Lkotlin/text/Regex;", "placeholderLookupCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/willfp/eco/internal/placeholder/PlaceholderLookup;", "kotlin.jvm.PlatformType", "Lcom/willfp/eco/core/placeholder/Placeholder;", "placeholderRegex", "prettyMathExpressionRegex", "doGetResult", "", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "args", "injections", "", "Lcom/willfp/eco/core/placeholder/InjectablePlaceholder;", "context", "Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;", "getPlaceholderResult", "parseIndividualEcoPlaceholder", "string", "parseIndividualPlaceholders", "strings", "translateEcoPlaceholdersIn", "text", "translatePlacholders", "translateEcoPlaceholders", "", "core-backend"})
@SourceDebugExtension(value={"SMAP\nPlaceholderParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaceholderParser.kt\ncom/willfp/eco/internal/placeholder/PlaceholderParser\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1284#2,3:236\n1284#2,3:239\n1789#3,3:242\n1789#3,3:245\n1789#3,3:248\n1789#3,3:251\n1549#3:254\n1620#3,3:255\n*S KotlinDebug\n*F\n+ 1 PlaceholderParser.kt\ncom/willfp/eco/internal/placeholder/PlaceholderParser\n*L\n49#1:236,3\n57#1:239,3\n85#1:242,3\n94#1:245,3\n116#1:248,3\n121#1:251,3\n198#1:254\n198#1:255,3\n*E\n"})
public final class PlaceholderParser {
    @NotNull
    private final Regex placeholderRegex = new Regex("%([^% ]+)%");
    @NotNull
    private final Regex prettyMathExpressionRegex = new Regex("(\\{\\^\\{)(.)+(}})");
    @NotNull
    private final Regex mathExpressionRegex = new Regex("(\\{\\{)(.)+(}})");
    private final Cache<PlaceholderLookup, Placeholder> placeholderLookupCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();

    @NotNull
    public final String translatePlacholders(@NotNull String text, @NotNull PlaceholderContext context) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(context, "context");
        List<InjectablePlaceholder> list = context.getInjectableContext().getPlaceholderInjections();
        Intrinsics.checkNotNullExpressionValue(list, "getPlaceholderInjections(...)");
        return PlaceholderParser.translatePlacholders$default(this, text, context, list, false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String translatePlacholders(String text, PlaceholderContext context, Collection<? extends InjectablePlaceholder> injections, boolean translateEcoPlaceholders) {
        Object matchResult;
        String acc;
        Object element$iv;
        Iterator iterator2;
        String accumulator$iv;
        boolean $i$f$fold;
        Object $this$fold$iv;
        String processed = text;
        if (StringsKt.contains$default((CharSequence)processed, '{', false, 2, null)) {
            double result2;
            String expression;
            if (StringsKt.contains$default((CharSequence)processed, '^', false, 2, null)) {
                $this$fold$iv = Regex.findAll$default(this.prettyMathExpressionRegex, processed, 0, 2, null);
                $i$f$fold = false;
                accumulator$iv = processed;
                iterator2 = $this$fold$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    MatchResult matchResult2 = (MatchResult)element$iv;
                    acc = accumulator$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(matchResult.getValue().substring(3, matchResult.getValue().length() - 2), "substring(...)");
                    result2 = NumberUtilsExtensions.evaluateExpression(expression, context);
                    accumulator$iv = StringsKt.replace$default(acc, matchResult.getValue(), StringUtilsExtensions.toNiceString(result2), false, 4, null);
                }
                processed = accumulator$iv;
            }
            $this$fold$iv = Regex.findAll$default(this.mathExpressionRegex, processed, 0, 2, null);
            $i$f$fold = false;
            accumulator$iv = processed;
            iterator2 = $this$fold$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                matchResult = (MatchResult)element$iv;
                acc = accumulator$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(matchResult.getValue().substring(2, matchResult.getValue().length() - 2), "substring(...)");
                result2 = NumberUtilsExtensions.evaluateExpression(expression, context);
                accumulator$iv = StringsKt.replace$default(acc, matchResult.getValue(), String.valueOf(result2), false, 4, null);
            }
            processed = accumulator$iv;
        }
        $this$fold$iv = injections;
        $i$f$fold = false;
        accumulator$iv = processed;
        iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void injection;
            element$iv = iterator2.next();
            matchResult = (InjectablePlaceholder)element$iv;
            acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(injection.tryTranslateQuickly(acc, context), "tryTranslateQuickly(...)");
        }
        processed = accumulator$iv;
        Collection<AdditionalPlayer> collection = context.getAdditionalPlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getAdditionalPlayers(...)");
        if (!collection.isEmpty()) {
            List<String> found = PlaceholderManager.findPlaceholdersIn(text);
            for (AdditionalPlayer additionalPlayer : context.getAdditionalPlayers()) {
                String prefix = "%" + additionalPlayer.getIdentifier() + "_";
                Intrinsics.checkNotNull(found);
                Iterable $this$fold$iv2 = found;
                boolean $i$f$fold2 = false;
                String accumulator$iv2 = processed;
                for (Object element$iv2 : $this$fold$iv2) {
                    String string;
                    void placeholder2;
                    String result3 = (String)element$iv2;
                    String acc2 = accumulator$iv2;
                    boolean bl = false;
                    Intrinsics.checkNotNull(placeholder2);
                    if (StringsKt.startsWith$default((String)placeholder2, prefix, false, 2, null)) {
                        String newPlaceholder = "%" + StringUtils.removePrefix(prefix, (String)placeholder2);
                        PlaceholderContext placeholderContext = context.copyWithPlayer(additionalPlayer.getPlayer());
                        Intrinsics.checkNotNullExpressionValue(placeholderContext, "copyWithPlayer(...)");
                        String translation = PlaceholderParser.translatePlacholders$default(this, newPlaceholder, placeholderContext, injections, false, 8, null);
                        string = StringsKt.replace$default(acc2, (String)placeholder2, translation, false, 4, null);
                    } else {
                        string = acc2;
                    }
                    accumulator$iv2 = string;
                }
                processed = accumulator$iv2;
            }
        }
        if (translateEcoPlaceholders) {
            processed = this.translateEcoPlaceholdersIn(processed, context, injections);
        }
        Set<PlaceholderIntegration> set = PlaceholderManager.getRegisteredIntegrations();
        Intrinsics.checkNotNullExpressionValue(set, "getRegisteredIntegrations(...)");
        $this$fold$iv = set;
        $i$f$fold = false;
        accumulator$iv = processed;
        iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void integration;
            element$iv = iterator2.next();
            PlaceholderIntegration $i$f$fold2 = (PlaceholderIntegration)element$iv;
            acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(integration.translate(acc, context.getPlayer()), "translate(...)");
        }
        processed = accumulator$iv;
        $this$fold$iv = injections;
        $i$f$fold = false;
        accumulator$iv = processed;
        iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void injection;
            element$iv = iterator2.next();
            InjectablePlaceholder integration = (InjectablePlaceholder)element$iv;
            acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(injection.tryTranslateQuickly(acc, context), "tryTranslateQuickly(...)");
        }
        return accumulator$iv;
    }

    static /* synthetic */ String translatePlacholders$default(PlaceholderParser placeholderParser, String string, PlaceholderContext placeholderContext, Collection collection, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return placeholderParser.translatePlacholders(string, placeholderContext, collection, bl);
    }

    @Nullable
    public final String getPlaceholderResult(@Nullable EcoPlugin plugin, @NotNull String args2, @NotNull PlaceholderContext context) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(context, "context");
        List<InjectablePlaceholder> injections = plugin == null ? context.getInjectableContext().getPlaceholderInjections() : null;
        return this.doGetResult(plugin, args2, (Collection<? extends InjectablePlaceholder>)injections, context);
    }

    private final String doGetResult(EcoPlugin plugin, String args2, Collection<? extends InjectablePlaceholder> injections, PlaceholderContext context) {
        Placeholder placeholder2;
        if (args2 == null) {
            return null;
        }
        PlaceholderLookup lookup = new PlaceholderLookup(args2, plugin, injections);
        Placeholder placeholder3 = placeholder2 = this.placeholderLookupCache.get(lookup, arg_0 -> PlaceholderParser.doGetResult$lambda$6(doGetResult.placeholder.1.INSTANCE, arg_0));
        return placeholder3 != null ? placeholder3.getValue(args2, context) : null;
    }

    private final String translateEcoPlaceholdersIn(String text, PlaceholderContext context, Collection<? extends InjectablePlaceholder> injections) {
        StringBuilder output = new StringBuilder();
        int lastAppendPosition = 0;
        Iterator iterator2 = Regex.findAll$default(this.placeholderRegex, text, 0, 2, null).iterator();
        while (iterator2.hasNext()) {
            EcoPlugin plugin;
            MatchResult matchResult = (MatchResult)iterator2.next();
            Object object = matchResult.getGroups().get(1);
            if (object == null || (object = ((MatchGroup)object).getValue()) == null) {
                object = "";
            }
            Object placeholder2 = object;
            String injectableResult = this.doGetResult(null, (String)placeholder2, injections, context);
            String[] stringArray = new String[]{"_"};
            List parts = StringsKt.split$default((CharSequence)placeholder2, stringArray, false, 2, 2, null);
            String result2 = null;
            if (injectableResult != null) {
                result2 = injectableResult;
            } else if (parts.size() == 2 && (plugin = EcoPlugin.getPlugin((String)parts.get(0))) != null) {
                result2 = this.doGetResult(plugin, (String)parts.get(1), null, context);
            }
            String string = text.substring(lastAppendPosition, matchResult.getRange().getFirst());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            output.append(string);
            String string2 = result2;
            if (string2 == null) {
                string2 = matchResult.getValue();
            }
            output.append(string2);
            lastAppendPosition = matchResult.getRange().getLast() + 1;
        }
        String string = text.substring(lastAppendPosition);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        output.append(string);
        String string3 = output.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> parseIndividualPlaceholders(@NotNull Collection<String> strings, @NotNull PlaceholderContext context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(strings, "strings");
        Intrinsics.checkNotNullParameter(context, "context");
        List<InjectablePlaceholder> list = context.getInjectableContext().getPlaceholderInjections();
        Intrinsics.checkNotNullExpressionValue(list, "getPlaceholderInjections(...)");
        List<InjectablePlaceholder> injections = list;
        Iterable $this$map$iv = strings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = this.parseIndividualEcoPlaceholder((String)it, context, (Collection<? extends InjectablePlaceholder>)injections);
            if (string2 == null) {
                string2 = this.translatePlacholders((String)it, context, (Collection<? extends InjectablePlaceholder>)injections, false);
            }
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    private final String parseIndividualEcoPlaceholder(String string, PlaceholderContext context, Collection<? extends InjectablePlaceholder> injections) {
        EcoPlugin plugin;
        String string2 = string.substring(1, string.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String placeholder2 = string2;
        String injectableResult = this.doGetResult(null, placeholder2, injections, context);
        if (injectableResult != null) {
            return injectableResult;
        }
        String[] stringArray = new String[]{"_"};
        List parts = StringsKt.split$default((CharSequence)placeholder2, stringArray, false, 2, 2, null);
        if (parts.size() == 2 && (plugin = EcoPlugin.getPlugin((String)parts.get(0))) != null) {
            return this.doGetResult(plugin, (String)parts.get(1), null, context);
        }
        return null;
    }

    private static final Placeholder doGetResult$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Placeholder)$tmp0.invoke(p0);
    }
}

