/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.data;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0007J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/internal/spigot/data/PlayerBlockListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "onBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "onExtend", "Lorg/bukkit/event/block/BlockPistonExtendEvent;", "onGrow", "Lorg/bukkit/event/world/StructureGrowEvent;", "onPlace", "Lorg/bukkit/event/block/BlockMultiPlaceEvent;", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onRetract", "Lorg/bukkit/event/block/BlockPistonRetractEvent;", "removeKey", "location", "Lorg/bukkit/Location;", "block", "Lorg/bukkit/block/Block;", "writeKey", "core-plugin"})
public final class PlayerBlockListener
implements Listener {
    @NotNull
    private final EcoPlugin plugin;

    public PlayerBlockListener(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPlace(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getBlockPlaced();
        Intrinsics.checkNotNullExpressionValue(block, "getBlockPlaced(...)");
        Block block2 = block;
        this.writeKey(block2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onPlace(@NotNull BlockMultiPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getBlockPlaced();
        Intrinsics.checkNotNullExpressionValue(block, "getBlockPlaced(...)");
        Block block2 = block;
        this.writeKey(block2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        this.plugin.getScheduler().run(() -> PlayerBlockListener.onBreak$lambda$0(this, block2));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onGrow(@NotNull StructureGrowEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        this.plugin.getScheduler().run(() -> PlayerBlockListener.onGrow$lambda$1(this, block2));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onExtend(@NotNull BlockPistonExtendEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        List locs = new ArrayList();
        List toRemove = new ArrayList();
        for (Block block : event.getBlocks()) {
            if (!BlockUtils.isPlayerPlaced(block)) continue;
            Location location = block.getRelative(event.getDirection()).getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            locs.add(location);
            Location location2 = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            toRemove.add(location2);
        }
        this.plugin.getScheduler().run(() -> PlayerBlockListener.onExtend$lambda$2(toRemove, this, locs));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onRetract(@NotNull BlockPistonRetractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        List locs = new ArrayList();
        List toRemove = new ArrayList();
        for (Block block : event.getBlocks()) {
            if (!BlockUtils.isPlayerPlaced(block)) continue;
            Location location = block.getRelative(event.getDirection()).getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            locs.add(location);
            Location location2 = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            toRemove.add(location2);
        }
        this.plugin.getScheduler().run(() -> PlayerBlockListener.onRetract$lambda$3(toRemove, this, locs));
    }

    private final void writeKey(Block block) {
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.writeKey(location);
    }

    private final void writeKey(Location location) {
        String string = Integer.toString(location.hashCode(), CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String loc = string;
        PersistentDataContainer persistentDataContainer = location.getChunk().getPersistentDataContainer();
        String string2 = loc.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        persistentDataContainer.set(this.plugin.createNamespacedKey(string2), PersistentDataType.INTEGER, (Object)1);
    }

    private final void removeKey(Block block) {
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.removeKey(location);
    }

    private final void removeKey(Location location) {
        String string = Integer.toString(location.hashCode(), CharsKt.checkRadix(16));
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String loc = string;
        PersistentDataContainer persistentDataContainer = location.getChunk().getPersistentDataContainer();
        String string2 = loc.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        persistentDataContainer.remove(this.plugin.createNamespacedKey(string2));
    }

    private static final void onBreak$lambda$0(PlayerBlockListener this$0, Block $block) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($block, "$block");
        this$0.removeKey($block);
    }

    private static final void onGrow$lambda$1(PlayerBlockListener this$0, Block $block) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($block, "$block");
        this$0.removeKey($block);
    }

    private static final void onExtend$lambda$2(List $toRemove, PlayerBlockListener this$0, List $locs) {
        Intrinsics.checkNotNullParameter($toRemove, "$toRemove");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($locs, "$locs");
        for (Location loc : $toRemove) {
            this$0.removeKey(loc);
        }
        for (Location loc : $locs) {
            this$0.writeKey(loc);
        }
    }

    private static final void onRetract$lambda$3(List $toRemove, PlayerBlockListener this$0, List $locs) {
        Intrinsics.checkNotNullParameter($toRemove, "$toRemove");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($locs, "$locs");
        for (Location loc : $toRemove) {
            this$0.removeKey(loc);
        }
        for (Location loc : $locs) {
            this$0.writeKey(loc);
        }
    }
}

