/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.data.storage;

import com.willfp.eco.core.data.keys.PersistentDataKey;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.internal.spigot.EcoSpigotPlugin;
import com.willfp.eco.internal.spigot.data.DataYml;
import com.willfp.eco.internal.spigot.data.ProfileHandler;
import com.willfp.eco.internal.spigot.data.storage.DataHandler;
import com.willfp.eco.internal.spigot.data.storage.HandlerType;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.NamespacedKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J/\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J(\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0004\u0012\u00020\u00100\u001eH\u0016J5\u0010\u001f\u001a\u00020\n\"\b\b\u0000\u0010\u0017*\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00182\u0006\u0010\u000f\u001a\u0002H\u0017H\u0016\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/willfp/eco/internal/spigot/data/storage/YamlDataHandler;", "Lcom/willfp/eco/internal/spigot/data/storage/DataHandler;", "plugin", "Lcom/willfp/eco/internal/spigot/EcoSpigotPlugin;", "handler", "Lcom/willfp/eco/internal/spigot/data/ProfileHandler;", "(Lcom/willfp/eco/internal/spigot/EcoSpigotPlugin;Lcom/willfp/eco/internal/spigot/data/ProfileHandler;)V", "dataYml", "Lcom/willfp/eco/internal/spigot/data/DataYml;", "doWrite", "", "uuid", "Ljava/util/UUID;", "key", "Lorg/bukkit/NamespacedKey;", "value", "", "equals", "", "other", "hashCode", "", "read", "T", "Lcom/willfp/eco/core/data/keys/PersistentDataKey;", "(Ljava/util/UUID;Lcom/willfp/eco/core/data/keys/PersistentDataKey;)Ljava/lang/Object;", "save", "saveAsync", "saveKeysFor", "keys", "", "write", "(Ljava/util/UUID;Lcom/willfp/eco/core/data/keys/PersistentDataKey;Ljava/lang/Object;)V", "core-plugin"})
public final class YamlDataHandler
extends DataHandler {
    @NotNull
    private final ProfileHandler handler;
    @NotNull
    private final DataYml dataYml;

    public YamlDataHandler(@NotNull EcoSpigotPlugin plugin, @NotNull ProfileHandler handler) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(handler, "handler");
        super(HandlerType.YAML);
        this.handler = handler;
        this.dataYml = plugin.getDataYml();
    }

    @Override
    public void save() {
        this.dataYml.save();
    }

    @Override
    public void saveAsync() {
        this.dataYml.saveAsync();
    }

    @Override
    @Nullable
    public <T> T read(@NotNull UUID uuid, @NotNull PersistentDataKey<T> key) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(key, "key");
        PersistentDataKeyType<T> persistentDataKeyType = key.getType();
        Object value = Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.INT) ? (Object)this.dataYml.getIntOrNull("player." + uuid + "." + key.getKey()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.DOUBLE) ? (Object)this.dataYml.getDoubleOrNull("player." + uuid + "." + key.getKey()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.STRING) ? (Object)this.dataYml.getStringOrNull("player." + uuid + "." + key.getKey()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.BOOLEAN) ? (Object)this.dataYml.getBoolOrNull("player." + uuid + "." + key.getKey()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.STRING_LIST) ? (Object)this.dataYml.getStringsOrNull("player." + uuid + "." + key.getKey()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.CONFIG) ? (Object)this.dataYml.getSubsectionOrNull("player." + uuid + "." + key.getKey()) : (Intrinsics.areEqual(persistentDataKeyType, PersistentDataKeyType.BIG_DECIMAL) ? (Object)this.dataYml.getBigDecimalOrNull("player." + uuid + "." + key.getKey()) : null))))));
        return (T)value;
    }

    @Override
    public <T> void write(@NotNull UUID uuid, @NotNull PersistentDataKey<T> key, @NotNull T value) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        NamespacedKey namespacedKey = key.getKey();
        Intrinsics.checkNotNullExpressionValue(namespacedKey, "getKey(...)");
        this.doWrite(uuid, namespacedKey, value);
    }

    @Override
    public void saveKeysFor(@NotNull UUID uuid, @NotNull Map<PersistentDataKey<?>, ? extends Object> keys2) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(keys2, "keys");
        for (Map.Entry<PersistentDataKey<?>, Object> entry : keys2.entrySet()) {
            PersistentDataKey<?> key = entry.getKey();
            Object value = entry.getValue();
            NamespacedKey namespacedKey = key.getKey();
            Intrinsics.checkNotNullExpressionValue(namespacedKey, "getKey(...)");
            this.doWrite(uuid, namespacedKey, value);
        }
    }

    private final void doWrite(UUID uuid, NamespacedKey key, Object value) {
        this.dataYml.set("player." + uuid + "." + key, value);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof YamlDataHandler;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }
}

