/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.antigrief;

import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.managers.PvPManager;
import org.kingdoms.managers.land.BuildingProcessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/antigrief/AntigriefKingdoms;", "Lcom/willfp/eco/core/integrations/antigrief/AntigriefIntegration;", "()V", "canBreakBlock", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "canCreateExplosion", "location", "Lorg/bukkit/Location;", "canInjure", "victim", "Lorg/bukkit/entity/LivingEntity;", "canPickupItem", "canPlaceBlock", "equals", "other", "", "getPluginName", "", "hashCode", "", "core-plugin"})
public final class AntigriefKingdoms
implements AntigriefIntegration {
    @Override
    public boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)((OfflinePlayer)player));
        Intrinsics.checkNotNullExpressionValue(kingdomPlayer, "getKingdomPlayer(...)");
        KingdomPlayer kp = kingdomPlayer;
        if (kp.isAdmin()) {
            return true;
        }
        return new BuildingProcessor((OfflinePlayer)player, kp, SimpleChunkLocation.of((Block)block), false).process().isSuccessful();
    }

    @Override
    public boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        Block block = location.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        return this.canBreakBlock(player, block);
    }

    @Override
    public boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)((OfflinePlayer)player));
        Intrinsics.checkNotNullExpressionValue(kingdomPlayer, "getKingdomPlayer(...)");
        KingdomPlayer kp = kingdomPlayer;
        if (kp.isAdmin()) {
            return true;
        }
        return new BuildingProcessor((OfflinePlayer)player, kp, SimpleChunkLocation.of((Block)block), true).process().isSuccessful();
    }

    @Override
    public boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(victim, "victim");
        if (victim instanceof Player) {
            bl = PvPManager.canFight((Player)player, (Player)((Player)victim));
        } else {
            Land land = Land.getLand((Location)victim.getLocation());
            if (land == null) {
                return true;
            }
            Land land2 = land;
            if (!land2.isClaimed()) {
                return true;
            }
            Kingdom kingdom = land2.getKingdom();
            Intrinsics.checkNotNullExpressionValue(kingdom, "getKingdom(...)");
            Kingdom kingdom2 = kingdom;
            bl = kingdom2.isMember((OfflinePlayer)player);
        }
        return bl;
    }

    @Override
    public boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        return true;
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "Kingdoms";
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AntigriefIntegration)) {
            return false;
        }
        return Intrinsics.areEqual(((AntigriefIntegration)other).getPluginName(), this.getPluginName());
    }

    public int hashCode() {
        return this.getPluginName().hashCode();
    }
}

