/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.antigrief;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.type.Flags;
import me.angeschossen.lands.api.land.Area;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/antigrief/AntigriefLands;", "Lcom/willfp/eco/core/integrations/antigrief/AntigriefIntegration;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "landsIntegration", "Lme/angeschossen/lands/api/LandsIntegration;", "Lcom/willfp/eco/libs/jetbrains/annotations/NotNull;", "canBreakBlock", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "canCreateExplosion", "location", "Lorg/bukkit/Location;", "canInjure", "victim", "Lorg/bukkit/entity/LivingEntity;", "canPickupItem", "canPlaceBlock", "equals", "other", "", "getPluginName", "", "hashCode", "", "core-plugin"})
public final class AntigriefLands
implements AntigriefIntegration {
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private final LandsIntegration landsIntegration;

    public AntigriefLands(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        LandsIntegration landsIntegration = LandsIntegration.of((Plugin)((Plugin)this.plugin));
        Intrinsics.checkNotNullExpressionValue(landsIntegration, "of(...)");
        this.landsIntegration = landsIntegration;
    }

    @Override
    public boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Area area = this.landsIntegration.getArea(block.getLocation());
        if (area == null) {
            return true;
        }
        Area area2 = area;
        return area2.hasRoleFlag(player, Flags.BLOCK_BREAK, block.getType(), false);
    }

    @Override
    public boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        Area area = this.landsIntegration.getArea(location);
        if (area == null) {
            return true;
        }
        Area area2 = area;
        return area2.hasRoleFlag(player, Flags.ATTACK_PLAYER, Material.AIR, false) && area2.hasRoleFlag(player, Flags.ATTACK_ANIMAL, Material.AIR, false);
    }

    @Override
    public boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Area area = this.landsIntegration.getArea(block.getLocation());
        if (area == null) {
            return true;
        }
        Area area2 = area;
        return area2.hasRoleFlag(player, Flags.BLOCK_PLACE, Material.AIR, false);
    }

    @Override
    public boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(victim, "victim");
        Area area = this.landsIntegration.getArea(victim.getLocation());
        if (area == null) {
            return true;
        }
        Area area2 = area;
        LivingEntity livingEntity = victim;
        return livingEntity instanceof Player ? area2.hasRoleFlag(player, Flags.ATTACK_PLAYER, Material.AIR, false) : (livingEntity instanceof Monster ? area2.hasRoleFlag(player, Flags.ATTACK_MONSTER, Material.AIR, false) : (livingEntity instanceof Animals ? area2.hasRoleFlag(player, Flags.ATTACK_ANIMAL, Material.AIR, false) : area2.isTrusted(player.getUniqueId())));
    }

    @Override
    public boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        Area area = this.landsIntegration.getArea(location);
        if (area == null) {
            return true;
        }
        Area area2 = area;
        return area2.hasRoleFlag(player, Flags.ITEM_PICKUP, Material.AIR, false);
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "Lands";
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AntigriefIntegration)) {
            return false;
        }
        return Intrinsics.areEqual(((AntigriefIntegration)other).getPluginName(), this.getPluginName());
    }

    public int hashCode() {
        return this.getPluginName().hashCode();
    }
}

