/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.antigrief;

import com.bgsoftware.superiorskyblock.api.SuperiorSkyblockAPI;
import com.bgsoftware.superiorskyblock.api.enums.HitActionResult;
import com.bgsoftware.superiorskyblock.api.island.Island;
import com.bgsoftware.superiorskyblock.api.island.IslandPrivilege;
import com.bgsoftware.superiorskyblock.api.wrappers.SuperiorPlayer;
import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/antigrief/AntigriefSuperiorSkyblock2;", "Lcom/willfp/eco/core/integrations/antigrief/AntigriefIntegration;", "()V", "canBreakBlock", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "canCreateExplosion", "location", "Lorg/bukkit/Location;", "canInjure", "victim", "Lorg/bukkit/entity/LivingEntity;", "canPickupItem", "canPlaceBlock", "getPluginName", "", "core-plugin"})
public final class AntigriefSuperiorSkyblock2
implements AntigriefIntegration {
    @Override
    @NotNull
    public String getPluginName() {
        return "SuperiorSkyblock2";
    }

    @Override
    public boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)block.getLocation());
        SuperiorPlayer superiorPlayer = SuperiorSkyblockAPI.getPlayer((Player)player);
        if (island == null) {
            return superiorPlayer.hasBypassModeEnabled() || !SuperiorSkyblockAPI.getSuperiorSkyblock().getGrid().isIslandsWorld(superiorPlayer.getWorld());
        }
        if (!island.hasPermission(superiorPlayer, IslandPrivilege.getByName((String)"BREAK"))) {
            return false;
        }
        return island.isInsideRange(block.getLocation());
    }

    @Override
    public boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        if (SuperiorSkyblockAPI.getPlayer((Player)player).hasBypassModeEnabled()) {
            return true;
        }
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        return island != null ? island.isMember(SuperiorSkyblockAPI.getPlayer((Player)player)) : true;
    }

    @Override
    public boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)block.getLocation());
        SuperiorPlayer superiorPlayer = SuperiorSkyblockAPI.getPlayer((Player)player);
        Intrinsics.checkNotNullExpressionValue(superiorPlayer, "getPlayer(...)");
        SuperiorPlayer superiorPlayer2 = superiorPlayer;
        if (island == null) {
            return superiorPlayer2.hasBypassModeEnabled() || !SuperiorSkyblockAPI.getSuperiorSkyblock().getGrid().isIslandsWorld(superiorPlayer2.getWorld());
        }
        if (!island.hasPermission(superiorPlayer2, IslandPrivilege.getByName((String)"BUILD"))) {
            return false;
        }
        return island.isInsideRange(block.getLocation());
    }

    @Override
    public boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        IslandPrivilege islandPermission;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(victim, "victim");
        Island island = SuperiorSkyblockAPI.getSuperiorSkyblock().getGrid().getIslandAt(victim.getLocation());
        if (victim instanceof Player) {
            return SuperiorSkyblockAPI.getPlayer((Player)player).canHit(SuperiorSkyblockAPI.getPlayer((Player)((Player)victim))).equals((Object)HitActionResult.SUCCESS);
        }
        IslandPrivilege islandPrivilege = islandPermission = victim instanceof Monster ? IslandPrivilege.getByName((String)"MONSTER_DAMAGE") : IslandPrivilege.getByName((String)"ANIMAL_DAMAGE");
        return island == null || island.hasPermission((CommandSender)player, islandPermission);
    }

    @Override
    public boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        SuperiorPlayer superiorPlayer = SuperiorSkyblockAPI.getPlayer((Player)player);
        Intrinsics.checkNotNullExpressionValue(superiorPlayer, "getPlayer(...)");
        SuperiorPlayer superiorPlayer2 = superiorPlayer;
        Island island = SuperiorSkyblockAPI.getSuperiorSkyblock().getGrid().getIslandAt(location);
        if (island == null) {
            return true;
        }
        Island island2 = island;
        return island2.hasPermission(superiorPlayer2, IslandPrivilege.getByName((String)"PICKUP_DROPS"));
    }
}

