/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.antigrief;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.willfp.eco.core.integrations.antigrief.AntigriefIntegration;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/antigrief/AntigriefWorldGuard;", "Lcom/willfp/eco/core/integrations/antigrief/AntigriefIntegration;", "()V", "canBreakBlock", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "canCreateExplosion", "location", "Lorg/bukkit/Location;", "canInjure", "victim", "Lorg/bukkit/entity/LivingEntity;", "canPickupItem", "canPlaceBlock", "equals", "other", "", "getPluginName", "", "hashCode", "", "core-plugin"})
public final class AntigriefWorldGuard
implements AntigriefIntegration {
    @Override
    public boolean canBreakBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        Intrinsics.checkNotNullExpressionValue(localPlayer, "wrapPlayer(...)");
        LocalPlayer localPlayer2 = localPlayer;
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        Intrinsics.checkNotNullExpressionValue(regionContainer, "getRegionContainer(...)");
        RegionContainer container = regionContainer;
        RegionQuery regionQuery = container.createQuery();
        Intrinsics.checkNotNullExpressionValue(regionQuery, "createQuery(...)");
        RegionQuery query2 = regionQuery;
        StateFlag[] stateFlagArray = new StateFlag[]{Flags.BLOCK_BREAK};
        return !query2.testBuild(BukkitAdapter.adapt((Location)block.getLocation()), localPlayer2, stateFlagArray) ? WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer2, BukkitAdapter.adapt((World)block.getWorld())) : true;
    }

    @Override
    public boolean canCreateExplosion(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        Intrinsics.checkNotNullExpressionValue(localPlayer, "wrapPlayer(...)");
        LocalPlayer localPlayer2 = localPlayer;
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        Intrinsics.checkNotNullExpressionValue(regionContainer, "getRegionContainer(...)");
        RegionContainer container = regionContainer;
        RegionQuery regionQuery = container.createQuery();
        Intrinsics.checkNotNullExpressionValue(regionQuery, "createQuery(...)");
        RegionQuery query2 = regionQuery;
        World world = location.getWorld();
        Validate.notNull((Object)world, (String)"World cannot be null!");
        StateFlag[] stateFlagArray = new StateFlag[]{Flags.TNT};
        return !query2.testBuild(BukkitAdapter.adapt((Location)location), localPlayer2, stateFlagArray) ? WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer2, BukkitAdapter.adapt((World)world)) : true;
    }

    @Override
    public boolean canPlaceBlock(@NotNull Player player, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(block, "block");
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        Intrinsics.checkNotNullExpressionValue(localPlayer, "wrapPlayer(...)");
        LocalPlayer localPlayer2 = localPlayer;
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        Intrinsics.checkNotNullExpressionValue(regionContainer, "getRegionContainer(...)");
        RegionContainer container = regionContainer;
        RegionQuery regionQuery = container.createQuery();
        Intrinsics.checkNotNullExpressionValue(regionQuery, "createQuery(...)");
        RegionQuery query2 = regionQuery;
        StateFlag[] stateFlagArray = new StateFlag[]{Flags.BLOCK_PLACE};
        return !query2.testBuild(BukkitAdapter.adapt((Location)block.getLocation()), localPlayer2, stateFlagArray) ? WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer2, BukkitAdapter.adapt((World)block.getWorld())) : true;
    }

    @Override
    public boolean canInjure(@NotNull Player player, @NotNull LivingEntity victim) {
        StateFlag stateFlag;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(victim, "victim");
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        Intrinsics.checkNotNullExpressionValue(localPlayer, "wrapPlayer(...)");
        LocalPlayer localPlayer2 = localPlayer;
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        Intrinsics.checkNotNullExpressionValue(regionContainer, "getRegionContainer(...)");
        RegionContainer container = regionContainer;
        RegionQuery regionQuery = container.createQuery();
        Intrinsics.checkNotNullExpressionValue(regionQuery, "createQuery(...)");
        RegionQuery query2 = regionQuery;
        StateFlag[] stateFlagArray = victim;
        if (stateFlagArray instanceof Player) {
            stateFlag = Flags.PVP;
        } else if (stateFlagArray instanceof Monster) {
            stateFlag = Flags.MOB_DAMAGE;
        } else if (stateFlagArray instanceof Animals) {
            stateFlag = Flags.DAMAGE_ANIMALS;
        } else if (stateFlagArray instanceof ArmorStand) {
            stateFlag = Flags.INTERACT;
        } else {
            return true;
        }
        StateFlag flag = stateFlag;
        stateFlagArray = new StateFlag[]{flag};
        return !query2.testBuild(BukkitAdapter.adapt((Location)victim.getLocation()), localPlayer2, stateFlagArray) ? WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer2, BukkitAdapter.adapt((World)player.getWorld())) : true;
    }

    @Override
    public boolean canPickupItem(@NotNull Player player, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        Intrinsics.checkNotNullExpressionValue(localPlayer, "wrapPlayer(...)");
        LocalPlayer localPlayer2 = localPlayer;
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        Intrinsics.checkNotNullExpressionValue(regionContainer, "getRegionContainer(...)");
        RegionContainer container = regionContainer;
        RegionQuery regionQuery = container.createQuery();
        Intrinsics.checkNotNullExpressionValue(regionQuery, "createQuery(...)");
        RegionQuery query2 = regionQuery;
        World world = location.getWorld();
        Validate.notNull((Object)world, (String)"World cannot be null!");
        StateFlag[] stateFlagArray = new StateFlag[]{Flags.ITEM_PICKUP};
        return !query2.testBuild(BukkitAdapter.adapt((Location)location), localPlayer2, stateFlagArray) ? WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer2, BukkitAdapter.adapt((World)world)) : true;
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "WorldGuard";
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AntigriefIntegration)) {
            return false;
        }
        return Intrinsics.areEqual(((AntigriefIntegration)other).getPluginName(), this.getPluginName());
    }

    public int hashCode() {
        return this.getPluginName().hashCode();
    }
}

