/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.integrations.price;

import com.willfp.eco.core.placeholder.context.PlaceholderContext;
import com.willfp.eco.core.placeholder.context.PlaceholderContextSupplier;
import com.willfp.eco.core.price.Price;
import com.willfp.eco.core.price.PriceFactory;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.ListUtilsExtensions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.qKing12.RoyaleEconomy.MultiCurrency.Currency;
import org.bukkit.entity.Player;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/price/PriceFactoryRoyaleEconomy;", "Lcom/willfp/eco/core/price/PriceFactory;", "currency", "Lme/qKing12/RoyaleEconomy/MultiCurrency/Currency;", "(Lme/qKing12/RoyaleEconomy/MultiCurrency/Currency;)V", "create", "Lcom/willfp/eco/core/price/Price;", "baseContext", "Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;", "function", "Lcom/willfp/eco/core/placeholder/context/PlaceholderContextSupplier;", "", "getNames", "", "", "PriceRoyaleEconomy", "core-plugin"})
public final class PriceFactoryRoyaleEconomy
implements PriceFactory {
    @NotNull
    private final Currency currency;

    public PriceFactoryRoyaleEconomy(@NotNull Currency currency) {
        Intrinsics.checkNotNullParameter(currency, "currency");
        this.currency = currency;
    }

    @Override
    @NotNull
    public List<String> getNames() {
        String string = this.currency.getCurrencyId();
        Intrinsics.checkNotNullExpressionValue(string, "getCurrencyId(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return ListUtilsExtensions.toSingletonList(string2);
    }

    @Override
    @NotNull
    public Price create(@NotNull PlaceholderContext baseContext, @NotNull PlaceholderContextSupplier<Double> function) {
        Intrinsics.checkNotNullParameter(baseContext, "baseContext");
        Intrinsics.checkNotNullParameter(function, "function");
        return new PriceRoyaleEconomy(this.currency, baseContext, (Function1<? super PlaceholderContext, Double>)new Function1<PlaceholderContext, Double>(function){
            final /* synthetic */ PlaceholderContextSupplier<Double> $function;
            {
                this.$function = $function;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull PlaceholderContext it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Double d = this.$function.get(it);
                Intrinsics.checkNotNullExpressionValue(d, "get(...)");
                return d;
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/internal/spigot/integrations/price/PriceFactoryRoyaleEconomy$PriceRoyaleEconomy;", "Lcom/willfp/eco/core/price/Price;", "currency", "Lme/qKing12/RoyaleEconomy/MultiCurrency/Currency;", "baseContext", "Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;", "function", "Lkotlin/Function1;", "", "(Lme/qKing12/RoyaleEconomy/MultiCurrency/Currency;Lcom/willfp/eco/core/placeholder/context/PlaceholderContext;Lkotlin/jvm/functions/Function1;)V", "multipliers", "", "Ljava/util/UUID;", "canAfford", "", "player", "Lorg/bukkit/entity/Player;", "multiplier", "getMultiplier", "getValue", "giveTo", "", "pay", "setMultiplier", "core-plugin"})
    private static final class PriceRoyaleEconomy
    implements Price {
        @NotNull
        private final Currency currency;
        @NotNull
        private final PlaceholderContext baseContext;
        @NotNull
        private final Function1<PlaceholderContext, Double> function;
        @NotNull
        private final Map<UUID, Double> multipliers;

        public PriceRoyaleEconomy(@NotNull Currency currency, @NotNull PlaceholderContext baseContext, @NotNull Function1<? super PlaceholderContext, Double> function) {
            Intrinsics.checkNotNullParameter(currency, "currency");
            Intrinsics.checkNotNullParameter(baseContext, "baseContext");
            Intrinsics.checkNotNullParameter(function, "function");
            this.currency = currency;
            this.baseContext = baseContext;
            this.function = function;
            this.multipliers = new LinkedHashMap();
        }

        @Override
        public boolean canAfford(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            return this.currency.getAmount(player.getUniqueId().toString()) >= this.getValue(player, multiplier);
        }

        @Override
        public void pay(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            this.currency.removeAmount(player.getUniqueId().toString(), this.getValue(player, multiplier));
        }

        @Override
        public void giveTo(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            this.currency.addAmount(player.getUniqueId().toString(), this.getValue(player, multiplier));
        }

        @Override
        public double getValue(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            PlaceholderContext placeholderContext = this.baseContext.copyWithPlayer(player);
            Intrinsics.checkNotNullExpressionValue(placeholderContext, "copyWithPlayer(...)");
            return ((Number)this.function.invoke(placeholderContext)).doubleValue() * this.getMultiplier(player) * multiplier;
        }

        @Override
        public double getMultiplier(@NotNull Player player) {
            Intrinsics.checkNotNullParameter(player, "player");
            Double d = this.multipliers.get(player.getUniqueId());
            return d != null ? d : 1.0;
        }

        @Override
        public void setMultiplier(@NotNull Player player, double multiplier) {
            Intrinsics.checkNotNullParameter(player, "player");
            Map<UUID, Double> map2 = this.multipliers;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            UUID uUID2 = uUID;
            Double d = multiplier;
            map2.put(uUID2, d);
        }
    }
}

