/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.inbuild;

import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Transformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.examination.ExaminableProperty;

public final class ClickTransformation
extends Transformation {
    private final ClickEvent.Action action;
    private final String value;

    public static ClickTransformation create(String name, List<TagPart> args2) {
        if (args2.size() != 2) {
            throw new ParsingException("Don't know how to turn " + args2 + " into a click event", args2);
        }
        @Nullable ClickEvent.Action action = ClickEvent.Action.NAMES.value(args2.get(0).value().toLowerCase(Locale.ROOT));
        String value = args2.get(1).value();
        if (action == null) {
            throw new ParsingException("Unknown click event action '" + args2.get(0).value() + "'", args2);
        }
        return new ClickTransformation(action, value);
    }

    private ClickTransformation(ClickEvent.Action action, String value) {
        this.action = action;
        this.value = value;
    }

    @Override
    public Component apply() {
        return Component.empty().clickEvent(ClickEvent.clickEvent(this.action, this.value));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", (Object)this.action), ExaminableProperty.of("value", this.value));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClickTransformation that = (ClickTransformation)other;
        return this.action == that.action && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.value});
    }
}

