/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.inbuild;

import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.Transformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import net.kyori.examination.ExaminableProperty;

public final class FontTransformation
extends Transformation {
    private final Key font;

    public static FontTransformation create(String name, List<TagPart> args2) {
        Key font;
        if (args2.size() == 1) {
            String fontKey = args2.get(0).value();
            font = Key.key(fontKey);
        } else if (args2.size() == 2) {
            String namespaceKey = args2.get(0).value();
            String fontKey = args2.get(1).value();
            font = Key.key(namespaceKey, fontKey);
        } else {
            throw new ParsingException("Don't know how to turn " + args2 + " into a font", args2);
        }
        return new FontTransformation(font);
    }

    private FontTransformation(Key font) {
        this.font = font;
    }

    @Override
    public Component apply() {
        return Component.empty().style(Style.style().font(this.font));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("font", this.font));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FontTransformation that = (FontTransformation)other;
        return Objects.equals(this.font, that.font);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.font);
    }
}

