/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.inbuild;

import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.Transformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.examination.ExaminableProperty;

public final class InsertionTransformation
extends Transformation {
    private final String insertion;

    public static InsertionTransformation create(String name, List<TagPart> args2) {
        if (args2.size() != 1) {
            throw new ParsingException("Doesn't know how to turn token with name '" + name + "' and arguments " + args2 + " into a insertion component", args2);
        }
        return new InsertionTransformation(args2.get(0).value());
    }

    private InsertionTransformation(String insertion) {
        this.insertion = insertion;
    }

    @Override
    public Component apply() {
        return Component.empty().insertion(this.insertion);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("insertion", this.insertion));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InsertionTransformation that = (InsertionTransformation)other;
        return Objects.equals(this.insertion, that.insertion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.insertion);
    }
}

