/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.internal.parser.node;

import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.internal.parser.ParsingExceptionImpl;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.internal.parser.Token;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.internal.parser.TokenParser;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.internal.parser.node.ElementNode;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.internal.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_19_R2.minimessage.tag.Tag;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TagNode
extends ElementNode {
    private final List<TagPart> parts;
    @Nullable
    private Tag tag = null;

    public TagNode(@NotNull ElementNode parent, @NotNull Token token2, @NotNull String sourceMessage, @NotNull TokenParser.TagProvider tagProvider) {
        super(parent, token2, sourceMessage);
        this.parts = TagNode.genParts(token2, sourceMessage, tagProvider);
        if (this.parts.isEmpty()) {
            throw new ParsingExceptionImpl("Tag has no parts? " + this, this.sourceMessage(), this.token());
        }
    }

    @NotNull
    private static List<TagPart> genParts(@NotNull Token token2, @NotNull String sourceMessage, @NotNull TokenParser.TagProvider tagProvider) {
        ArrayList<TagPart> parts = new ArrayList<TagPart>();
        if (token2.childTokens() != null) {
            for (Token childToken : token2.childTokens()) {
                parts.add(new TagPart(sourceMessage, childToken, tagProvider));
            }
        }
        return parts;
    }

    @NotNull
    public List<TagPart> parts() {
        return this.parts;
    }

    @NotNull
    public String name() {
        return this.parts.get(0).value();
    }

    @Override
    @NotNull
    public Token token() {
        return Objects.requireNonNull(super.token(), "token is not set");
    }

    @NotNull
    public Tag tag() {
        return Objects.requireNonNull(this.tag, "no tag set");
    }

    public void tag(@NotNull Tag tag) {
        this.tag = tag;
    }

    @Override
    @NotNull
    public StringBuilder buildToString(@NotNull StringBuilder sb, int indent) {
        char[] in = this.ident(indent);
        sb.append(in).append("TagNode(");
        int size = this.parts.size();
        for (int i = 0; i < size; ++i) {
            TagPart part = this.parts.get(i);
            sb.append('\'').append(part.value()).append('\'');
            if (i == size - 1) continue;
            sb.append(", ");
        }
        sb.append(") {\n");
        for (ElementNode child : this.children()) {
            child.buildToString(sb, indent + 1);
        }
        sb.append(in).append("}\n");
        return sb;
    }
}

