/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_20_R1.common.ai;

import com.willfp.eco.core.entities.ai.CustomGoal;
import com.willfp.eco.core.entities.ai.EntityController;
import com.willfp.eco.core.entities.ai.EntityGoal;
import com.willfp.eco.core.entities.ai.TargetGoal;
import com.willfp.eco.internal.spigot.proxy.v1_20_R1.common.NMSCommonsKt;
import com.willfp.eco.internal.spigot.proxy.v1_20_R1.common.ai.CustomGoalFactory;
import com.willfp.eco.internal.spigot.proxy.v1_20_R1.common.ai.EntityGoalFactory;
import com.willfp.eco.internal.spigot.proxy.v1_20_R1.common.ai.EntityGoalsKt;
import com.willfp.eco.internal.spigot.proxy.v1_20_R1.common.ai.TargetGoalFactory;
import com.willfp.eco.internal.spigot.proxy.v1_20_R1.common.ai.TargetGoalsKt;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import org.bukkit.entity.Mob;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000bH\u0016J&\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u000bH\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\rH\u0016R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/willfp/eco/internal/spigot/proxy/v1_20_R1/common/ai/EcoEntityController;", "T", "Lorg/bukkit/entity/Mob;", "Lcom/willfp/eco/core/entities/ai/EntityController;", "handle", "(Lorg/bukkit/entity/Mob;)V", "Lorg/bukkit/entity/Mob;", "addEntityGoal", "priority", "", "goal", "Lcom/willfp/eco/core/entities/ai/EntityGoal;", "addTargetGoal", "Lcom/willfp/eco/core/entities/ai/TargetGoal;", "clearEntityGoals", "clearTargetGoals", "getEntity", "()Lorg/bukkit/entity/Mob;", "getNms", "Lnet/minecraft/world/entity/PathfinderMob;", "removeEntityGoal", "removeTargetGoal", "nms-common"})
public final class EcoEntityController<T extends Mob>
implements EntityController<T> {
    @NotNull
    private final T handle;

    public EcoEntityController(@NotNull T handle) {
        Intrinsics.checkNotNullParameter(handle, "handle");
        this.handle = handle;
    }

    @Override
    @NotNull
    public EntityController<T> addEntityGoal(int priority, @NotNull EntityGoal<? super T> goal) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        EntityCreature entityCreature = this.getNms();
        if (entityCreature == null) {
            return this;
        }
        EntityCreature nms = entityCreature;
        PathfinderGoal pathfinderGoal = EntityGoalsKt.getGoalFactory(goal);
        if (pathfinderGoal == null || (pathfinderGoal = pathfinderGoal.create(goal, nms)) == null) {
            return this;
        }
        nms.bO.a(priority, pathfinderGoal);
        return this;
    }

    @Override
    @NotNull
    public EntityController<T> removeEntityGoal(@NotNull EntityGoal<? super T> goal) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        EntityCreature entityCreature = this.getNms();
        if (entityCreature == null) {
            return this;
        }
        EntityCreature nms = entityCreature;
        Function1 predicate2 = goal instanceof CustomGoal ? (Function1)new Function1<PathfinderGoal, Boolean>(goal){
            final /* synthetic */ EntityGoal<? super T> $goal;
            {
                this.$goal = $goal;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PathfinderGoal it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return CustomGoalFactory.INSTANCE.isGoalOfType(it, (CustomGoal)this.$goal);
            }
        } : (Function1)new Function1<PathfinderGoal, Boolean>(goal){
            final /* synthetic */ EntityGoal<? super T> $goal;
            {
                this.$goal = $goal;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PathfinderGoal it) {
                Intrinsics.checkNotNullParameter(it, "it");
                EntityGoalFactory<EntityGoal<T>> entityGoalFactory = EntityGoalsKt.getGoalFactory(this.$goal);
                return entityGoalFactory != null ? entityGoalFactory.isGoalOfType(it) : false;
            }
        };
        Set set = nms.bO.d;
        Intrinsics.checkNotNullExpressionValue(set, "availableGoals");
        for (PathfinderGoalWrapped wrapped : CollectionsKt.toSet(set)) {
            PathfinderGoal pathfinderGoal = wrapped.k();
            Intrinsics.checkNotNullExpressionValue(pathfinderGoal, "getGoal(...)");
            if (!((Boolean)predicate2.invoke(pathfinderGoal)).booleanValue()) continue;
            nms.bO.a(wrapped.k());
        }
        return this;
    }

    @Override
    @NotNull
    public EntityController<T> clearEntityGoals() {
        EntityCreature entityCreature = this.getNms();
        if (entityCreature == null) {
            return this;
        }
        EntityCreature nms = entityCreature;
        nms.bO.d.clear();
        return this;
    }

    @Override
    @NotNull
    public EntityController<T> addTargetGoal(int priority, @NotNull TargetGoal<? super T> goal) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        EntityCreature entityCreature = this.getNms();
        if (entityCreature == null) {
            return this;
        }
        EntityCreature nms = entityCreature;
        PathfinderGoal pathfinderGoal = TargetGoalsKt.getGoalFactory(goal);
        if (pathfinderGoal == null || (pathfinderGoal = pathfinderGoal.create(goal, nms)) == null) {
            return this;
        }
        nms.bP.a(priority, pathfinderGoal);
        PathfinderGoalSelector cfr_ignored_0 = nms.bP;
        return this;
    }

    @Override
    @NotNull
    public EntityController<T> removeTargetGoal(@NotNull TargetGoal<? super T> goal) {
        Intrinsics.checkNotNullParameter(goal, "goal");
        EntityCreature entityCreature = this.getNms();
        if (entityCreature == null) {
            return this;
        }
        EntityCreature nms = entityCreature;
        Function1 predicate2 = goal instanceof CustomGoal ? (Function1)new Function1<PathfinderGoal, Boolean>(goal){
            final /* synthetic */ TargetGoal<? super T> $goal;
            {
                this.$goal = $goal;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PathfinderGoal it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return CustomGoalFactory.INSTANCE.isGoalOfType(it, (CustomGoal)this.$goal);
            }
        } : (Function1)new Function1<PathfinderGoal, Boolean>(goal){
            final /* synthetic */ TargetGoal<? super T> $goal;
            {
                this.$goal = $goal;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PathfinderGoal it) {
                Intrinsics.checkNotNullParameter(it, "it");
                TargetGoalFactory<TargetGoal<T>> targetGoalFactory = TargetGoalsKt.getGoalFactory(this.$goal);
                return targetGoalFactory != null ? targetGoalFactory.isGoalOfType(it) : false;
            }
        };
        Set set = nms.bP.d;
        Intrinsics.checkNotNullExpressionValue(set, "availableGoals");
        for (PathfinderGoalWrapped wrapped : CollectionsKt.toSet(set)) {
            PathfinderGoal pathfinderGoal = wrapped.k();
            Intrinsics.checkNotNullExpressionValue(pathfinderGoal, "getGoal(...)");
            if (!((Boolean)predicate2.invoke(pathfinderGoal)).booleanValue()) continue;
            nms.bP.a(wrapped.k());
        }
        return this;
    }

    @Override
    @NotNull
    public EntityController<T> clearTargetGoals() {
        EntityCreature entityCreature = this.getNms();
        if (entityCreature == null) {
            return this;
        }
        EntityCreature nms = entityCreature;
        nms.bP.d.clear();
        return this;
    }

    private final EntityCreature getNms() {
        return NMSCommonsKt.toPathfinderMob(this.handle);
    }

    @Override
    @NotNull
    public T getEntity() {
        return this.handle;
    }
}

