/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.recipes;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.recipe.Recipes;
import com.willfp.eco.core.recipe.recipes.CraftingRecipe;
import com.willfp.eco.internal.spigot.recipes.RecipeListener;
import com.willfp.eco.internal.spigot.recipes.RecipeValidator;
import com.willfp.eco.internal.spigot.recipes.WrappedCraftItemEvent;
import com.willfp.eco.internal.spigot.recipes.WrappedPrepareItemCraftEvent;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.bukkit.inventory.Recipe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/willfp/eco/internal/spigot/recipes/CraftingRecipeListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lcom/willfp/eco/core/EcoPlugin;", "(Lcom/willfp/eco/core/EcoPlugin;)V", "getPlugin", "()Lcom/willfp/eco/core/EcoPlugin;", "handlePrepare", "", "event", "Lorg/bukkit/event/inventory/PrepareItemCraftEvent;", "preventLearningDisplayedRecipes", "Lorg/bukkit/event/player/PlayerRecipeDiscoverEvent;", "processListeners", "Lorg/bukkit/event/inventory/CraftItemEvent;", "Companion", "core-plugin"})
public final class CraftingRecipeListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EcoPlugin plugin;
    @NotNull
    private static final List<RecipeValidator> validators = new ArrayList();
    @NotNull
    private static final List<RecipeListener> listeners = new ArrayList();

    public CraftingRecipeListener(@NotNull EcoPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @NotNull
    public final EcoPlugin getPlugin() {
        return this.plugin;
    }

    @EventHandler
    public final void preventLearningDisplayedRecipes(@NotNull PlayerRecipeDiscoverEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!EcoPlugin.getPluginNames().contains(event.getRecipe().getNamespace())) {
            return;
        }
        String string = event.getRecipe().getKey();
        Intrinsics.checkNotNullExpressionValue(string, "getKey(...)");
        if (StringsKt.contains$default((CharSequence)string, "_displayed", false, 2, null)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void processListeners(@NotNull PrepareItemCraftEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.handlePrepare(event);
        if (this.plugin.getConfigYml().getBool("enforce-preparing-recipes")) {
            this.plugin.getScheduler().runLater(1L, () -> CraftingRecipeListener.processListeners$lambda$0(this, event));
        }
    }

    private final void handlePrepare(PrepareItemCraftEvent event) {
        CraftingRecipe ecoRecipe;
        Keyed recipe;
        Recipe recipe2 = event.getRecipe();
        Keyed keyed = recipe = recipe2 instanceof Keyed ? (Keyed)recipe2 : null;
        if (recipe == null && (ecoRecipe = Recipes.getMatch(event.getInventory().getMatrix())) != null) {
            recipe = () -> CraftingRecipeListener.handlePrepare$lambda$1(ecoRecipe);
        }
        if (recipe == null) {
            return;
        }
        for (RecipeListener listener : listeners) {
            listener.handle(new WrappedPrepareItemCraftEvent(event, recipe));
        }
    }

    @EventHandler
    public final void processListeners(@NotNull CraftItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getRecipe() instanceof Keyed)) {
            return;
        }
        for (RecipeListener listener : listeners) {
            listener.handle(new WrappedCraftItemEvent(event));
        }
    }

    private static final void processListeners$lambda$0(CraftingRecipeListener this$0, PrepareItemCraftEvent $event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($event, "$event");
        this$0.handlePrepare($event);
    }

    private static final NamespacedKey handlePrepare$lambda$1(CraftingRecipe $ecoRecipe) {
        return $ecoRecipe.getKey();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/willfp/eco/internal/spigot/recipes/CraftingRecipeListener$Companion;", "", "()V", "listeners", "", "Lcom/willfp/eco/internal/spigot/recipes/RecipeListener;", "validators", "Lcom/willfp/eco/internal/spigot/recipes/RecipeValidator;", "getValidators", "()Ljava/util/List;", "registerListener", "", "listener", "registerValidator", "validator", "core-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<RecipeValidator> getValidators() {
            return validators;
        }

        public final void registerValidator(@NotNull RecipeValidator validator) {
            Intrinsics.checkNotNullParameter(validator, "validator");
            this.getValidators().add(validator);
        }

        public final void registerListener(@NotNull RecipeListener listener) {
            Intrinsics.checkNotNullParameter(listener, "listener");
            listeners.add(listener);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

