/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson;

import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.assertions.Assertions;
import java.util.Arrays;

public final class BsonRegularExpression
extends BsonValue {
    private final String pattern;
    private final String options;

    public BsonRegularExpression(String pattern, String options2) {
        this.pattern = Assertions.notNull("pattern", pattern);
        this.options = options2 == null ? "" : this.sortOptionCharacters(options2);
    }

    public BsonRegularExpression(String pattern) {
        this(pattern, null);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.REGULAR_EXPRESSION;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonRegularExpression that = (BsonRegularExpression)o;
        if (!this.options.equals(that.options)) {
            return false;
        }
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        int result2 = this.pattern.hashCode();
        result2 = 31 * result2 + this.options.hashCode();
        return result2;
    }

    public String toString() {
        return "BsonRegularExpression{pattern='" + this.pattern + '\'' + ", options='" + this.options + '\'' + '}';
    }

    private String sortOptionCharacters(String options2) {
        char[] chars = options2.toCharArray();
        Arrays.sort(chars);
        return new String(chars);
    }
}

