/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.codecs.BsonDocumentCodec;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.configuration.CodecConfigurationException;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.conversions.Bson;

public class BsonCodec
implements Codec<Bson> {
    private static final Codec<BsonDocument> BSON_DOCUMENT_CODEC = new BsonDocumentCodec();
    private final CodecRegistry registry;

    public BsonCodec(CodecRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Bson decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("The BsonCodec can only encode to Bson");
    }

    @Override
    public void encode(BsonWriter writer, Bson value, EncoderContext encoderContext) {
        try {
            BsonDocument bsonDocument = value.toBsonDocument(BsonDocument.class, this.registry);
            BSON_DOCUMENT_CODEC.encode(writer, bsonDocument, encoderContext);
        }
        catch (Exception e) {
            throw new CodecConfigurationException(String.format("Unable to encode a Bson implementation: %s", value), e);
        }
    }

    @Override
    public Class<Bson> getEncoderClass() {
        return Bson.class;
    }
}

