/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonDocumentWriter;
import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.Transformer;
import com.willfp.eco.libs.bson.UuidRepresentation;
import com.willfp.eco.libs.bson.assertions.Assertions;
import com.willfp.eco.libs.bson.codecs.BsonTypeClassMap;
import com.willfp.eco.libs.bson.codecs.BsonTypeCodecMap;
import com.willfp.eco.libs.bson.codecs.BsonValueCodecProvider;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.CollectibleCodec;
import com.willfp.eco.libs.bson.codecs.CollectionCodecProvider;
import com.willfp.eco.libs.bson.codecs.ContainerCodecHelper;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.DocumentCodecProvider;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.IdGenerator;
import com.willfp.eco.libs.bson.codecs.IterableCodecProvider;
import com.willfp.eco.libs.bson.codecs.MapCodecProvider;
import com.willfp.eco.libs.bson.codecs.ObjectIdGenerator;
import com.willfp.eco.libs.bson.codecs.OverridableUuidRepresentationCodec;
import com.willfp.eco.libs.bson.codecs.ValueCodecProvider;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistries;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import java.util.Arrays;
import java.util.Map;

public class DocumentCodec
implements CollectibleCodec<Document>,
OverridableUuidRepresentationCodec<Document> {
    private static final String ID_FIELD_NAME = "_id";
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new CollectionCodecProvider(), new IterableCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider(), new MapCodecProvider()));
    private static final BsonTypeCodecMap DEFAULT_BSON_TYPE_CODEC_MAP = new BsonTypeCodecMap(BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP, DEFAULT_REGISTRY);
    private static final IdGenerator DEFAULT_ID_GENERATOR = new ObjectIdGenerator();
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final IdGenerator idGenerator;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    public DocumentCodec() {
        this(DEFAULT_REGISTRY, DEFAULT_BSON_TYPE_CODEC_MAP, null);
    }

    public DocumentCodec(CodecRegistry registry) {
        this(registry, BsonTypeClassMap.DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public DocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(registry, bsonTypeClassMap, null);
    }

    public DocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this(registry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry), valueTransformer);
    }

    private DocumentCodec(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, Transformer valueTransformer) {
        this(registry, bsonTypeCodecMap, DEFAULT_ID_GENERATOR, valueTransformer, UuidRepresentation.UNSPECIFIED);
    }

    private DocumentCodec(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, IdGenerator idGenerator, Transformer valueTransformer, UuidRepresentation uuidRepresentation) {
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.idGenerator = idGenerator;
        this.valueTransformer = valueTransformer != null ? valueTransformer : value -> value;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<Document> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new DocumentCodec(this.registry, this.bsonTypeCodecMap, this.idGenerator, this.valueTransformer, uuidRepresentation);
    }

    @Override
    public boolean documentHasId(Document document2) {
        return document2.containsKey(ID_FIELD_NAME);
    }

    @Override
    public BsonValue getDocumentId(Document document2) {
        if (!this.documentHasId(document2)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object id2 = document2.get(ID_FIELD_NAME);
        if (id2 instanceof BsonValue) {
            return (BsonValue)id2;
        }
        BsonDocument idHoldingDocument = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(idHoldingDocument);
        writer.writeStartDocument();
        writer.writeName(ID_FIELD_NAME);
        this.writeValue(writer, EncoderContext.builder().build(), id2);
        writer.writeEndDocument();
        return idHoldingDocument.get(ID_FIELD_NAME);
    }

    @Override
    public Document generateIdIfAbsentFromDocument(Document document2) {
        if (!this.documentHasId(document2)) {
            document2.put(ID_FIELD_NAME, this.idGenerator.generate());
        }
        return document2;
    }

    @Override
    public void encode(BsonWriter writer, Document document2, EncoderContext encoderContext) {
        writer.writeStartDocument();
        this.beforeFields(writer, encoderContext, document2);
        for (Map.Entry entry : document2.entrySet()) {
            if (this.skipField(encoderContext, (String)entry.getKey())) continue;
            writer.writeName((String)entry.getKey());
            this.writeValue(writer, encoderContext, entry.getValue());
        }
        writer.writeEndDocument();
    }

    @Override
    public Document decode(BsonReader reader, DecoderContext decoderContext) {
        Document document2 = new Document();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            document2.put(fieldName, ContainerCodecHelper.readValue(reader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer));
        }
        reader.readEndDocument();
        return document2;
    }

    @Override
    public Class<Document> getEncoderClass() {
        return Document.class;
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, Map<String, Object> document2) {
        if (encoderContext.isEncodingCollectibleDocument() && document2.containsKey(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, document2.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String key) {
        return encoderContext.isEncodingCollectibleDocument() && key.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter writer, EncoderContext encoderContext, Object value) {
        if (value == null) {
            writer.writeNull();
        } else {
            Codec<?> codec = this.registry.get(value.getClass());
            encoderContext.encodeWithChildContext(codec, writer, value);
        }
    }
}

