/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs;

import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.json.JsonObject;
import com.willfp.eco.libs.bson.json.JsonReader;
import com.willfp.eco.libs.bson.json.JsonWriter;
import com.willfp.eco.libs.bson.json.JsonWriterSettings;
import java.io.StringWriter;

public class JsonObjectCodec
implements Codec<JsonObject> {
    private final JsonWriterSettings writerSettings;

    public JsonObjectCodec() {
        this(JsonWriterSettings.builder().build());
    }

    public JsonObjectCodec(JsonWriterSettings writerSettings) {
        this.writerSettings = writerSettings;
    }

    @Override
    public void encode(BsonWriter writer, JsonObject value, EncoderContext encoderContext) {
        writer.pipe(new JsonReader(value.getJson()));
    }

    @Override
    public JsonObject decode(BsonReader reader, DecoderContext decoderContext) {
        StringWriter stringWriter = new StringWriter();
        new JsonWriter(stringWriter, this.writerSettings).pipe(reader);
        return new JsonObject(stringWriter.toString());
    }

    @Override
    public Class<JsonObject> getEncoderClass() {
        return JsonObject.class;
    }
}

