/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs.pojo;

import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.configuration.CodecConfigurationException;
import com.willfp.eco.libs.bson.codecs.pojo.PropertyCodecProvider;
import com.willfp.eco.libs.bson.codecs.pojo.PropertyCodecRegistry;
import com.willfp.eco.libs.bson.codecs.pojo.TypeData;
import com.willfp.eco.libs.bson.codecs.pojo.TypeWithTypeParameters;
import java.util.HashMap;
import java.util.Map;

final class MapPropertyCodecProvider
implements PropertyCodecProvider {
    MapPropertyCodecProvider() {
    }

    @Override
    public <T> Codec<T> get(TypeWithTypeParameters<T> type2, PropertyCodecRegistry registry) {
        if (Map.class.isAssignableFrom(type2.getType()) && type2.getTypeParameters().size() == 2) {
            Class<?> keyType = type2.getTypeParameters().get(0).getType();
            if (!keyType.equals(String.class)) {
                throw new CodecConfigurationException(String.format("Invalid Map type. Maps MUST have string keys, found %s instead.", keyType));
            }
            try {
                return new MapCodec(type2.getType(), registry.get(type2.getTypeParameters().get(1)));
            }
            catch (CodecConfigurationException e) {
                if (type2.getTypeParameters().get(1).getType() == Object.class) {
                    try {
                        return registry.get(TypeData.builder(Map.class).build());
                    }
                    catch (CodecConfigurationException codecConfigurationException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        return null;
    }

    private static class MapCodec<T>
    implements Codec<Map<String, T>> {
        private final Class<Map<String, T>> encoderClass;
        private final Codec<T> codec;

        MapCodec(Class<Map<String, T>> encoderClass, Codec<T> codec) {
            this.encoderClass = encoderClass;
            this.codec = codec;
        }

        @Override
        public void encode(BsonWriter writer, Map<String, T> map2, EncoderContext encoderContext) {
            writer.writeStartDocument();
            for (Map.Entry<String, T> entry : map2.entrySet()) {
                writer.writeName(entry.getKey());
                if (entry.getValue() == null) {
                    writer.writeNull();
                    continue;
                }
                this.codec.encode(writer, entry.getValue(), encoderContext);
            }
            writer.writeEndDocument();
        }

        @Override
        public Map<String, T> decode(BsonReader reader, DecoderContext context) {
            reader.readStartDocument();
            Map<String, T> map2 = this.getInstance();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (reader.getCurrentBsonType() == BsonType.NULL) {
                    map2.put(reader.readName(), null);
                    reader.readNull();
                    continue;
                }
                map2.put(reader.readName(), this.codec.decode(reader, context));
            }
            reader.readEndDocument();
            return map2;
        }

        @Override
        public Class<Map<String, T>> getEncoderClass() {
            return this.encoderClass;
        }

        private Map<String, T> getInstance() {
            if (this.encoderClass.isInterface()) {
                return new HashMap();
            }
            try {
                return this.encoderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new CodecConfigurationException(e.getMessage(), e);
            }
        }
    }
}

