/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs.pojo;

import com.willfp.eco.libs.annotation.Nullable;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonDocumentReader;
import com.willfp.eco.libs.bson.BsonDocumentWrapper;
import com.willfp.eco.libs.bson.BsonInvalidOperationException;
import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonReaderMark;
import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.codecs.BsonValueCodec;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.configuration.CodecConfigurationException;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.codecs.pojo.ClassModel;
import com.willfp.eco.libs.bson.codecs.pojo.DiscriminatorLookup;
import com.willfp.eco.libs.bson.codecs.pojo.IdPropertyModelHolder;
import com.willfp.eco.libs.bson.codecs.pojo.InstanceCreator;
import com.willfp.eco.libs.bson.codecs.pojo.LazyPropertyModelCodec;
import com.willfp.eco.libs.bson.codecs.pojo.PojoCodec;
import com.willfp.eco.libs.bson.codecs.pojo.PropertyCodecProvider;
import com.willfp.eco.libs.bson.codecs.pojo.PropertyCodecRegistry;
import com.willfp.eco.libs.bson.codecs.pojo.PropertyCodecRegistryImpl;
import com.willfp.eco.libs.bson.codecs.pojo.PropertyModel;
import com.willfp.eco.libs.bson.diagnostics.Logger;
import com.willfp.eco.libs.bson.diagnostics.Loggers;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

final class PojoCodecImpl<T>
extends PojoCodec<T> {
    private static final Logger LOGGER = Loggers.getLogger("PojoCodec");
    private static final Codec<BsonValue> BSON_VALUE_CODEC = new BsonValueCodec();
    private final ClassModel<T> classModel;
    private final CodecRegistry registry;
    private final PropertyCodecRegistry propertyCodecRegistry;
    private final DiscriminatorLookup discriminatorLookup;

    PojoCodecImpl(ClassModel<T> classModel, CodecRegistry codecRegistry, List<PropertyCodecProvider> propertyCodecProviders, DiscriminatorLookup discriminatorLookup) {
        this.classModel = classModel;
        this.registry = codecRegistry;
        this.discriminatorLookup = discriminatorLookup;
        this.propertyCodecRegistry = new PropertyCodecRegistryImpl(this, this.registry, propertyCodecProviders);
        this.specialize();
    }

    PojoCodecImpl(ClassModel<T> classModel, CodecRegistry codecRegistry, PropertyCodecRegistry propertyCodecRegistry, DiscriminatorLookup discriminatorLookup) {
        this.classModel = classModel;
        this.registry = codecRegistry;
        this.discriminatorLookup = discriminatorLookup;
        this.propertyCodecRegistry = propertyCodecRegistry;
        this.specialize();
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        if (this.areEquivalentTypes(value.getClass(), this.classModel.getType())) {
            writer.writeStartDocument();
            this.encodeIdProperty(writer, value, encoderContext, this.classModel.getIdPropertyModelHolder());
            if (this.classModel.useDiscriminator()) {
                writer.writeString(this.classModel.getDiscriminatorKey(), this.classModel.getDiscriminator());
            }
            for (PropertyModel<?> propertyModel : this.classModel.getPropertyModels()) {
                if (propertyModel.equals(this.classModel.getIdPropertyModel())) continue;
                this.encodeProperty(writer, value, encoderContext, propertyModel);
            }
            writer.writeEndDocument();
        } else {
            this.registry.get(value.getClass()).encode(writer, value, encoderContext);
        }
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        if (decoderContext.hasCheckedDiscriminator()) {
            InstanceCreator<T> instanceCreator = this.classModel.getInstanceCreator();
            this.decodeProperties(reader, decoderContext, instanceCreator);
            return instanceCreator.getInstance();
        }
        return this.getCodecFromDocument(reader, this.classModel.useDiscriminator(), this.classModel.getDiscriminatorKey(), this.registry, this.discriminatorLookup, this).decode(reader, DecoderContext.builder().checkedDiscriminator(true).build());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.classModel.getType();
    }

    public String toString() {
        return String.format("PojoCodec<%s>", this.classModel);
    }

    @Override
    ClassModel<T> getClassModel() {
        return this.classModel;
    }

    private <S> void encodeIdProperty(BsonWriter writer, T instance, EncoderContext encoderContext, IdPropertyModelHolder<S> propertyModelHolder) {
        if (propertyModelHolder.getPropertyModel() != null) {
            if (propertyModelHolder.getIdGenerator() == null) {
                this.encodeProperty(writer, instance, encoderContext, propertyModelHolder.getPropertyModel());
            } else {
                S id2 = propertyModelHolder.getPropertyModel().getPropertyAccessor().get(instance);
                if (id2 == null && encoderContext.isEncodingCollectibleDocument()) {
                    id2 = propertyModelHolder.getIdGenerator().generate();
                    try {
                        propertyModelHolder.getPropertyModel().getPropertyAccessor().set(instance, id2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.encodeValue(writer, encoderContext, propertyModelHolder.getPropertyModel(), id2);
            }
        }
    }

    private <S> void encodeProperty(BsonWriter writer, T instance, EncoderContext encoderContext, PropertyModel<S> propertyModel) {
        if (propertyModel != null && propertyModel.isReadable()) {
            S propertyValue = propertyModel.getPropertyAccessor().get(instance);
            this.encodeValue(writer, encoderContext, propertyModel, propertyValue);
        }
    }

    private <S> void encodeValue(BsonWriter writer, EncoderContext encoderContext, PropertyModel<S> propertyModel, S propertyValue) {
        if (propertyModel.shouldSerialize(propertyValue)) {
            try {
                if (propertyModel.getPropertySerialization().inline()) {
                    if (propertyValue != null) {
                        new BsonDocumentWrapper<S>(propertyValue, propertyModel.getCachedCodec()).forEach((k, v) -> {
                            writer.writeName((String)k);
                            encoderContext.encodeWithChildContext(this.registry.get(v.getClass()), writer, v);
                        });
                    }
                } else {
                    writer.writeName(propertyModel.getReadName());
                    if (propertyValue == null) {
                        writer.writeNull();
                    } else {
                        encoderContext.encodeWithChildContext(propertyModel.getCachedCodec(), writer, propertyValue);
                    }
                }
            }
            catch (CodecConfigurationException e) {
                throw new CodecConfigurationException(String.format("Failed to encode '%s'. Encoding '%s' errored with: %s", this.classModel.getName(), propertyModel.getReadName(), e.getMessage()), e);
            }
        }
    }

    private void decodeProperties(BsonReader reader, DecoderContext decoderContext, InstanceCreator<T> instanceCreator) {
        PropertyModel inlineElementsPropertyModel = this.classModel.getPropertyModels().stream().filter(p -> p.getPropertySerialization().inline()).findFirst().orElse(null);
        BsonDocument extraElements = inlineElementsPropertyModel == null ? null : new BsonDocument();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String name = reader.readName();
            if (this.classModel.useDiscriminator() && this.classModel.getDiscriminatorKey().equals(name)) {
                reader.readString();
                continue;
            }
            this.decodePropertyModel(reader, decoderContext, instanceCreator, name, this.getPropertyModelByWriteName(this.classModel, name), extraElements);
        }
        reader.readEndDocument();
        this.setPropertyValueBsonExtraElements(instanceCreator, extraElements, inlineElementsPropertyModel);
    }

    private <S> void decodePropertyModel(BsonReader reader, DecoderContext decoderContext, InstanceCreator<T> instanceCreator, String name, PropertyModel<S> propertyModel, @Nullable BsonDocument extraElements) {
        if (propertyModel != null) {
            this.setPropertyValue(instanceCreator, () -> {
                Object value = null;
                if (reader.getCurrentBsonType() == BsonType.NULL) {
                    reader.readNull();
                } else {
                    Codec codec = propertyModel.getCachedCodec();
                    if (codec == null) {
                        throw new CodecConfigurationException(String.format("Missing codec in '%s' for '%s'", this.classModel.getName(), propertyModel.getName()));
                    }
                    value = decoderContext.decodeWithChildContext(codec, reader);
                }
                return value;
            }, propertyModel);
        } else if (extraElements == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Found property not present in the ClassModel: %s", name));
            }
            reader.skipValue();
        } else {
            try {
                extraElements.append(name, decoderContext.decodeWithChildContext(BSON_VALUE_CODEC, reader));
            }
            catch (CodecConfigurationException e) {
                throw new CodecConfigurationException(String.format("Failed to decode '%s'. Decoding '%s' errored with: %s", this.classModel.getName(), name, e.getMessage()), e);
            }
        }
    }

    private <S> void setPropertyValue(InstanceCreator<T> instanceCreator, Supplier<S> valueSupplier, PropertyModel<S> propertyModel) {
        try {
            instanceCreator.set(valueSupplier.get(), propertyModel);
        }
        catch (BsonInvalidOperationException | CodecConfigurationException e) {
            throw new CodecConfigurationException(String.format("Failed to decode '%s'. Decoding '%s' errored with: %s", this.classModel.getName(), propertyModel.getName(), e.getMessage()), e);
        }
    }

    private <S> void setPropertyValueBsonExtraElements(InstanceCreator<T> instanceCreator, @Nullable BsonDocument extraElements, PropertyModel<S> inlineElementsPropertyModel) {
        if (extraElements != null && !extraElements.isEmpty() && inlineElementsPropertyModel != null && inlineElementsPropertyModel.isWritable()) {
            this.setPropertyValue(instanceCreator, () -> inlineElementsPropertyModel.getCachedCodec().decode(new BsonDocumentReader(extraElements), DecoderContext.builder().build()), inlineElementsPropertyModel);
        }
    }

    private void specialize() {
        this.classModel.getPropertyModels().forEach(this::cachePropertyModelCodec);
    }

    private <S> void cachePropertyModelCodec(PropertyModel<S> propertyModel) {
        if (propertyModel.getCachedCodec() == null) {
            LazyPropertyModelCodec<S> codec = propertyModel.getCodec() != null ? propertyModel.getCodec() : new LazyPropertyModelCodec<S>(propertyModel, this.registry, this.propertyCodecRegistry);
            propertyModel.cachedCodec(codec);
        }
    }

    private <S, V> boolean areEquivalentTypes(Class<S> t1, Class<V> t2) {
        if (t1.equals(t2)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(t1) && Collection.class.isAssignableFrom(t2)) {
            return true;
        }
        return Map.class.isAssignableFrom(t1) && Map.class.isAssignableFrom(t2);
    }

    private Codec<T> getCodecFromDocument(BsonReader reader, boolean useDiscriminator, String discriminatorKey, CodecRegistry registry, DiscriminatorLookup discriminatorLookup, Codec<T> defaultCodec) {
        Codec<Object> codec = defaultCodec;
        if (useDiscriminator) {
            BsonReaderMark mark = reader.getMark();
            reader.readStartDocument();
            boolean discriminatorKeyFound = false;
            while (!discriminatorKeyFound && reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                String name = reader.readName();
                if (discriminatorKey.equals(name)) {
                    discriminatorKeyFound = true;
                    try {
                        Class<?> discriminatorClass = discriminatorLookup.lookup(reader.readString());
                        if (codec.getEncoderClass().equals(discriminatorClass)) continue;
                        codec = registry.get(discriminatorClass);
                        continue;
                    }
                    catch (Exception e) {
                        throw new CodecConfigurationException(String.format("Failed to decode '%s'. Decoding errored with: %s", this.classModel.getName(), e.getMessage()), e);
                    }
                }
                reader.skipValue();
            }
            mark.reset();
        }
        return codec;
    }

    private PropertyModel<?> getPropertyModelByWriteName(ClassModel<T> classModel, String readName) {
        for (PropertyModel<?> propertyModel : classModel.getPropertyModels()) {
            if (!propertyModel.isWritable() || !propertyModel.getWriteName().equals(readName)) continue;
            return propertyModel;
        }
        return null;
    }

    @Override
    DiscriminatorLookup getDiscriminatorLookup() {
        return this.discriminatorLookup;
    }
}

