/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.diagnostics;

import com.willfp.eco.libs.bson.assertions.Assertions;
import com.willfp.eco.libs.bson.diagnostics.Logger;
import com.willfp.eco.libs.bson.diagnostics.NoOpLogger;
import com.willfp.eco.libs.bson.diagnostics.SLF4JLogger;

public final class Loggers {
    private static final String PREFIX = "com.willfp.eco.libs.bson";
    private static final boolean USE_SLF4J = Loggers.shouldUseSLF4J();

    public static Logger getLogger(String suffix) {
        Assertions.notNull("suffix", suffix);
        if (suffix.startsWith(".") || suffix.endsWith(".")) {
            throw new IllegalArgumentException("The suffix can not start or end with a '.'");
        }
        String name = "com.willfp.eco.libs.bson." + suffix;
        if (USE_SLF4J) {
            return new SLF4JLogger(name);
        }
        return new NoOpLogger(name);
    }

    private static boolean shouldUseSLF4J() {
        try {
            Class.forName("org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            java.util.logging.Logger.getLogger(PREFIX).warning(String.format("SLF4J not found on the classpath. Logging is disabled for the '%s' component", PREFIX));
            return false;
        }
    }

    private Loggers() {
    }
}

