/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.deserializers;

import com.willfp.eco.libs.bson4jackson.BsonParser;
import com.willfp.eco.libs.bson4jackson.types.JavaScript;
import com.willfp.eco.libs.jackson.core.JsonParser;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.core.TreeNode;
import com.willfp.eco.libs.jackson.databind.DeserializationContext;
import com.willfp.eco.libs.jackson.databind.JsonDeserializer;
import com.willfp.eco.libs.jackson.databind.node.ObjectNode;
import com.willfp.eco.libs.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.Map;

public class BsonJavaScriptDeserializer
extends JsonDeserializer<JavaScript> {
    @Override
    public JavaScript deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 13 && bsonParser.getCurrentBsonType() != 15) {
                throw ctxt.mappingException(JavaScript.class);
            }
            return (JavaScript)bsonParser.getEmbeddedObject();
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && jp.getEmbeddedObject() instanceof JavaScript) {
            return (JavaScript)jp.getEmbeddedObject();
        }
        Object tree = jp.getCodec().readTree(jp);
        String code = null;
        TreeNode codeNode = tree.get("$code");
        if (codeNode instanceof ValueNode) {
            code = ((ValueNode)codeNode).asText();
        }
        Map scope2 = null;
        TreeNode scopeNode = tree.get("$scope");
        if (scopeNode instanceof ObjectNode) {
            Map scope22;
            scope2 = scope22 = jp.getCodec().treeToValue(scopeNode, Map.class);
        }
        return new JavaScript(code, scope2);
    }
}

