/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.deserializers;

import com.willfp.eco.libs.bson4jackson.BsonParser;
import com.willfp.eco.libs.bson4jackson.types.Timestamp;
import com.willfp.eco.libs.jackson.core.JsonParser;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.databind.DeserializationContext;
import com.willfp.eco.libs.jackson.databind.JsonDeserializer;
import com.willfp.eco.libs.jackson.databind.node.ValueNode;
import java.io.IOException;

public class BsonTimestampDeserializer
extends JsonDeserializer<Timestamp> {
    @Override
    public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 17) {
                throw ctxt.mappingException(Timestamp.class);
            }
            return (Timestamp)bsonParser.getEmbeddedObject();
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && jp.getEmbeddedObject() instanceof Timestamp) {
            return (Timestamp)jp.getEmbeddedObject();
        }
        Object tree = jp.getCodec().readTree(jp);
        int time = ((ValueNode)tree.get("$time")).asInt();
        int inc = ((ValueNode)tree.get("$inc")).asInt();
        return new Timestamp(time, inc);
    }
}

