/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.serializers;

import com.willfp.eco.libs.bson4jackson.BsonGenerator;
import com.willfp.eco.libs.bson4jackson.types.ObjectId;
import com.willfp.eco.libs.jackson.core.JsonGenerator;
import com.willfp.eco.libs.jackson.databind.JsonSerializer;
import com.willfp.eco.libs.jackson.databind.SerializerProvider;
import java.io.IOException;

public class BsonObjectIdSerializer
extends JsonSerializer<ObjectId> {
    private final boolean useLegacyFormat;

    public BsonObjectIdSerializer() {
        this(false);
    }

    @Deprecated
    public BsonObjectIdSerializer(boolean useLegacyFormat) {
        this.useLegacyFormat = useLegacyFormat;
    }

    @Override
    public void serialize(ObjectId value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        if (value == null) {
            serializerProvider.defaultSerializeNull(gen);
        } else if (gen instanceof BsonGenerator) {
            BsonGenerator bgen = (BsonGenerator)gen;
            if (this.useLegacyFormat) {
                bgen.writeObjectIdLegacy(value);
            } else {
                bgen.writeObjectId(value);
            }
        } else {
            gen.writeStartObject();
            if (this.useLegacyFormat) {
                gen.writeNumberField("$time", value.getTime());
                gen.writeNumberField("$machine", value.getMachine());
                gen.writeNumberField("$inc", value.getInc());
            } else {
                gen.writeNumberField("$timestamp", value.getTimestamp());
                gen.writeNumberField("$randomValue1", value.getRandomValue1());
                gen.writeNumberField("$randomValue2", (int)value.getRandomValue2());
                gen.writeNumberField("$counter", value.getCounter());
            }
            gen.writeEndObject();
        }
    }
}

