/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.crunch.data;

import com.willfp.eco.libs.crunch.token.Token;
import java.util.function.Consumer;

public class TokenList {
    private Node head;
    private Node tail;
    private int size = 0;

    public void add(Token token2) {
        Node node = new Node(token2, this.tail, null);
        if (this.size == 0) {
            this.head = node;
        } else {
            this.tail.next = node;
        }
        this.tail = node;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public Node head() {
        return this.head;
    }

    public Node tail() {
        return this.tail;
    }

    public void forEach(Consumer<Token> lambda) {
        Node node = this.head;
        while (node != null) {
            lambda.accept(node.token);
            node = node.next;
        }
    }

    public class Node {
        public Token token;
        public Node next;
        public Node prev;

        public Node(Token token2, Node prev, Node next) {
            this.token = token2;
            this.prev = prev;
            this.next = next;
        }

        public void insertAfter(Token t2) {
            Node node;
            this.next = node = new Node(t2, this, this.next);
            if (node.next != null) {
                node.next.prev = node;
            }
            if (TokenList.this.tail == this) {
                TokenList.this.tail = node;
            }
            TokenList.this.size++;
        }

        public void insertBefore(Token t2) {
            Node node;
            this.prev = node = new Node(t2, this.prev, this);
            if (node.prev != null) {
                node.prev.next = node;
            }
            if (TokenList.this.head == this) {
                TokenList.this.head = node;
            }
            TokenList.this.size++;
        }

        public void removeAfter() {
            if (TokenList.this.tail == this) {
                throw new IllegalStateException("Cannot remove after tail");
            }
            if (this.next == TokenList.this.tail) {
                TokenList.this.tail = this;
            }
            if (this.next != null) {
                this.next = this.next.next;
                if (this.next != null) {
                    this.next.prev = this;
                }
            }
            TokenList.this.size--;
        }

        public void removeBefore() {
            if (TokenList.this.head == this) {
                throw new IllegalStateException("Cannot remove before head");
            }
            if (this.prev == TokenList.this.head) {
                TokenList.this.head = this;
            }
            if (this.prev != null) {
                this.prev = this.prev.prev;
                if (this.prev != null) {
                    this.prev.next = this;
                }
            }
            TokenList.this.size--;
        }
    }
}

