/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.jackson.module.kotlin;

import com.willfp.eco.libs.jackson.databind.BeanDescription;
import com.willfp.eco.libs.jackson.databind.DeserializationConfig;
import com.willfp.eco.libs.jackson.databind.deser.ValueInstantiator;
import com.willfp.eco.libs.jackson.databind.deser.ValueInstantiators;
import com.willfp.eco.libs.jackson.databind.deser.std.StdValueInstantiator;
import com.willfp.eco.libs.jackson.module.kotlin.KotlinModuleKt;
import com.willfp.eco.libs.jackson.module.kotlin.KotlinValueInstantiator;
import com.willfp.eco.libs.jackson.module.kotlin.ReflectionCache;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/willfp/eco/libs/jackson/module/kotlin/KotlinInstantiators;", "Lcom/willfp/eco/libs/jackson/databind/deser/ValueInstantiators;", "cache", "Lcom/willfp/eco/libs/jackson/module/kotlin/ReflectionCache;", "nullToEmptyCollection", "", "nullToEmptyMap", "nullIsSameAsDefault", "strictNullChecks", "(Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;ZZZZ)V", "findValueInstantiator", "Lcom/willfp/eco/libs/jackson/databind/deser/ValueInstantiator;", "deserConfig", "Lcom/willfp/eco/libs/jackson/databind/DeserializationConfig;", "beanDescriptor", "Lcom/willfp/eco/libs/jackson/databind/BeanDescription;", "defaultInstantiator", "jackson-module-kotlin"})
public final class KotlinInstantiators
implements ValueInstantiators {
    @NotNull
    private final ReflectionCache cache;
    private final boolean nullToEmptyCollection;
    private final boolean nullToEmptyMap;
    private final boolean nullIsSameAsDefault;
    private final boolean strictNullChecks;

    public KotlinInstantiators(@NotNull ReflectionCache cache2, boolean nullToEmptyCollection, boolean nullToEmptyMap, boolean nullIsSameAsDefault, boolean strictNullChecks) {
        Intrinsics.checkNotNullParameter(cache2, "cache");
        this.cache = cache2;
        this.nullToEmptyCollection = nullToEmptyCollection;
        this.nullToEmptyMap = nullToEmptyMap;
        this.nullIsSameAsDefault = nullIsSameAsDefault;
        this.strictNullChecks = strictNullChecks;
    }

    @Override
    @NotNull
    public ValueInstantiator findValueInstantiator(@NotNull DeserializationConfig deserConfig, @NotNull BeanDescription beanDescriptor, @NotNull ValueInstantiator defaultInstantiator) {
        ValueInstantiator valueInstantiator;
        Intrinsics.checkNotNullParameter(deserConfig, "deserConfig");
        Intrinsics.checkNotNullParameter(beanDescriptor, "beanDescriptor");
        Intrinsics.checkNotNullParameter(defaultInstantiator, "defaultInstantiator");
        Class<?> clazz = beanDescriptor.getBeanClass();
        Intrinsics.checkNotNullExpressionValue(clazz, "beanDescriptor.beanClass");
        if (KotlinModuleKt.isKotlinClass(clazz)) {
            if (!Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(defaultInstantiator.getClass()), Reflection.getOrCreateKotlinClass(StdValueInstantiator.class))) {
                throw new IllegalStateException("KotlinValueInstantiator requires that the default ValueInstantiator is StdValueInstantiator");
            }
            valueInstantiator = new KotlinValueInstantiator((StdValueInstantiator)defaultInstantiator, this.cache, this.nullToEmptyCollection, this.nullToEmptyMap, this.nullIsSameAsDefault, this.strictNullChecks);
        } else {
            valueInstantiator = defaultInstantiator;
        }
        return valueInstantiator;
    }
}

