/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.litote.kmongo.jackson;

import com.willfp.eco.libs.bson.BsonBinarySubType;
import com.willfp.eco.libs.bson.BsonTimestamp;
import com.willfp.eco.libs.bson.UuidRepresentation;
import com.willfp.eco.libs.bson.internal.UuidHelper;
import com.willfp.eco.libs.bson.types.Binary;
import com.willfp.eco.libs.bson.types.MaxKey;
import com.willfp.eco.libs.bson.types.MinKey;
import com.willfp.eco.libs.bson4jackson.BsonGenerator;
import com.willfp.eco.libs.bson4jackson.BsonParser;
import com.willfp.eco.libs.bson4jackson.types.Decimal128;
import com.willfp.eco.libs.bson4jackson.types.ObjectId;
import com.willfp.eco.libs.jackson.core.Base64Variants;
import com.willfp.eco.libs.jackson.core.JsonGenerator;
import com.willfp.eco.libs.jackson.core.JsonParser;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.core.TreeNode;
import com.willfp.eco.libs.jackson.databind.DeserializationContext;
import com.willfp.eco.libs.jackson.databind.JavaType;
import com.willfp.eco.libs.jackson.databind.JsonDeserializer;
import com.willfp.eco.libs.jackson.databind.JsonMappingException;
import com.willfp.eco.libs.jackson.databind.JsonNode;
import com.willfp.eco.libs.jackson.databind.JsonSerializer;
import com.willfp.eco.libs.jackson.databind.Module;
import com.willfp.eco.libs.jackson.databind.SerializerProvider;
import com.willfp.eco.libs.jackson.databind.deser.DeserializationProblemHandler;
import com.willfp.eco.libs.jackson.databind.deser.std.UUIDDeserializer;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.willfp.eco.libs.jackson.databind.module.SimpleModule;
import com.willfp.eco.libs.jackson.databind.node.BinaryNode;
import com.willfp.eco.libs.jackson.databind.node.POJONode;
import com.willfp.eco.libs.jackson.databind.node.TextNode;
import com.willfp.eco.libs.jackson.databind.node.ValueNode;
import com.willfp.eco.libs.jackson.databind.ser.std.UUIDSerializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.libs.litote.kmongo.Id;
import com.willfp.eco.libs.litote.kmongo.ProjectionsKt;
import com.willfp.eco.libs.litote.kmongo.id.IdTransformer;
import com.willfp.eco.libs.litote.kmongo.id.StringId;
import com.willfp.eco.libs.litote.kmongo.id.WrappedObjectId;
import com.willfp.eco.libs.litote.kmongo.id.jackson.IdKeyDeserializer;
import com.willfp.eco.libs.litote.kmongo.id.jackson.IdKeySerializer;
import com.willfp.eco.libs.litote.kmongo.jackson.ExtendedJsonModule;
import com.willfp.eco.libs.litote.kmongo.jackson.KMongoAnnotationIntrospector;
import com.willfp.eco.libs.litote.kmongo.jackson.KMongoBsonFactory;
import com.willfp.eco.libs.litote.kmongo.jackson.StringDeserializationProblemHandler;
import com.willfp.eco.libs.litote.kmongo.util.KotlinxDatetimeLoader;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b6\b\u0000\u0018\u00002\u00020\u0001:5\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006>"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule;", "Lcom/willfp/eco/libs/jackson/databind/module/SimpleModule;", "uuidRepresentation", "Lcom/willfp/eco/libs/bson/UuidRepresentation;", "(Lorg/bson/UuidRepresentation;)V", "setupModule", "", "context", "Lcom/willfp/eco/libs/jackson/databind/Module$SetupContext;", "AbstractIdBsonDeserializer", "BigDecimalBsonDeserializer", "BigDecimalBsonSerializer", "BinaryBsonDeserializer", "BinaryBsonSerializer", "BsonDateDeserializer", "BsonObjectIdDeserializer", "BsonTimestampBsonDeserializer", "BsonTimestampBsonSerializer", "CalendarBsonDeserializer", "CalendarBsonSerializer", "Decimal128BsonDeserializer", "Decimal128BsonSerializer", "IdBsonDeserializer", "IdBsonSerializer", "InstantBsonDeserializer", "InstantBsonSerializer", "KMongoObjectId", "KPropertySerializer", "KTXInstantBsonDeserializer", "KTXInstantBsonSerializer", "KTXLocalDateBsonDeserializer", "KTXLocalDateBsonSerializer", "KTXLocalDateTimeBsonDeserializer", "KTXLocalDateTimeBsonSerializer", "KTXLocalTimeBsonDeserializer", "KTXLocalTimeBsonSerializer", "LocalDateBsonDeserializer", "LocalDateBsonSerializer", "LocalDateTimeBsonDeserializer", "LocalDateTimeBsonSerializer", "LocalTimeBsonDeserializer", "LocalTimeBsonSerializer", "MaxKeyBsonDeserializer", "MaxKeyBsonSerializer", "MinKeyBsonDeserializer", "MinKeyBsonSerializer", "ObjectIdBsonDeserializer", "ObjectIdBsonSerializer", "OffsetDateTimeBsonDeserializer", "OffsetDateTimeBsonSerializer", "OffsetTimeBsonDeserializer", "OffsetTimeBsonSerializer", "StringIdBsonDeserializer", "TemporalBsonDeserializer", "TemporalBsonSerializer", "UuidDeserializer", "UuidSerializer", "WrappedObjectIdBsonDeserializer", "ZoneIdBsonDeserializer", "ZoneIdBsonSerializer", "ZonedDateTimeBsonDeserializer", "ZonedDateTimeBsonSerializer", "kmongo-jackson-mapping"})
public final class BsonModule
extends SimpleModule {
    public BsonModule(@Nullable UuidRepresentation uuidRepresentation) {
        this.addSerializer(com.willfp.eco.libs.bson.types.ObjectId.class, ObjectIdBsonSerializer.INSTANCE);
        this.addDeserializer(com.willfp.eco.libs.bson.types.ObjectId.class, ObjectIdBsonDeserializer.INSTANCE);
        this.addDeserializer(ObjectId.class, BsonObjectIdDeserializer.INSTANCE);
        this.addSerializer(Binary.class, BinaryBsonSerializer.INSTANCE);
        this.addDeserializer(Binary.class, BinaryBsonDeserializer.INSTANCE);
        this.addSerializer(BsonTimestamp.class, BsonTimestampBsonSerializer.INSTANCE);
        this.addDeserializer(BsonTimestamp.class, BsonTimestampBsonDeserializer.INSTANCE);
        this.addSerializer(MaxKey.class, MaxKeyBsonSerializer.INSTANCE);
        this.addDeserializer(MaxKey.class, MaxKeyBsonDeserializer.INSTANCE);
        this.addSerializer(MinKey.class, MinKeyBsonSerializer.INSTANCE);
        this.addDeserializer(MinKey.class, MinKeyBsonDeserializer.INSTANCE);
        this.addSerializer(BigDecimal.class, BigDecimalBsonSerializer.INSTANCE);
        this.addDeserializer(BigDecimal.class, BigDecimalBsonDeserializer.INSTANCE);
        this.addSerializer(Decimal128.class, Decimal128BsonSerializer.INSTANCE);
        this.addDeserializer(Decimal128.class, Decimal128BsonDeserializer.INSTANCE);
        this.addSerializer(Id.class, IdBsonSerializer.INSTANCE);
        this.addDeserializer(Id.class, IdBsonDeserializer.INSTANCE);
        this.addKeySerializer(Id.class, new IdKeySerializer());
        this.addKeyDeserializer(Id.class, new IdKeyDeserializer(null, 1, null));
        this.addDeserializer(StringId.class, StringIdBsonDeserializer.INSTANCE);
        this.addKeyDeserializer(StringId.class, new IdKeyDeserializer(null, 1, null));
        this.addDeserializer(WrappedObjectId.class, WrappedObjectIdBsonDeserializer.INSTANCE);
        this.addKeyDeserializer(WrappedObjectId.class, new IdKeyDeserializer(null, 1, null));
        this.addSerializer(Instant.class, InstantBsonSerializer.INSTANCE);
        this.addSerializer(ZonedDateTime.class, ZonedDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(OffsetDateTime.class, OffsetDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(LocalDate.class, LocalDateBsonSerializer.INSTANCE);
        this.addSerializer(java.time.LocalDateTime.class, LocalDateTimeBsonSerializer.INSTANCE);
        this.addSerializer(java.time.LocalTime.class, LocalTimeBsonSerializer.INSTANCE);
        this.addSerializer(OffsetTime.class, OffsetTimeBsonSerializer.INSTANCE);
        this.addSerializer(Calendar.class, CalendarBsonSerializer.INSTANCE);
        this.addDeserializer(Instant.class, InstantBsonDeserializer.INSTANCE);
        this.addDeserializer(ZonedDateTime.class, ZonedDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(OffsetDateTime.class, OffsetDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(LocalDate.class, LocalDateBsonDeserializer.INSTANCE);
        this.addDeserializer(java.time.LocalDateTime.class, LocalDateTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(java.time.LocalTime.class, LocalTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(OffsetTime.class, OffsetTimeBsonDeserializer.INSTANCE);
        this.addDeserializer(Calendar.class, CalendarBsonDeserializer.INSTANCE);
        this.addSerializer(ZoneId.class, ZoneIdBsonSerializer.INSTANCE);
        this.addDeserializer(ZoneId.class, ZoneIdBsonDeserializer.INSTANCE);
        this.addDeserializer(Date.class, BsonDateDeserializer.INSTANCE);
        this.addSerializer(KProperty.class, KPropertySerializer.INSTANCE);
        KotlinxDatetimeLoader.INSTANCE.loadKotlinxDateTime((Function0)new Function0<Object>(){

            @Override
            public final Object invoke() {
                this.addSerializer(kotlinx.datetime.Instant.class, KTXInstantBsonSerializer.INSTANCE);
                this.addSerializer(kotlinx.datetime.LocalDate.class, KTXLocalDateBsonSerializer.INSTANCE);
                this.addSerializer(LocalDateTime.class, KTXLocalDateTimeBsonSerializer.INSTANCE);
                this.addSerializer(LocalTime.class, KTXLocalTimeBsonSerializer.INSTANCE);
                this.addDeserializer(kotlinx.datetime.Instant.class, KTXInstantBsonDeserializer.INSTANCE);
                this.addDeserializer(kotlinx.datetime.LocalDate.class, KTXLocalDateBsonDeserializer.INSTANCE);
                this.addDeserializer(LocalDateTime.class, KTXLocalDateTimeBsonDeserializer.INSTANCE);
                return this.addDeserializer(LocalTime.class, KTXLocalTimeBsonDeserializer.INSTANCE);
            }
        }, 2.INSTANCE);
        if (uuidRepresentation != null) {
            this.addSerializer(UUID.class, new UuidSerializer(uuidRepresentation));
            this.addDeserializer(UUID.class, new UuidDeserializer(uuidRepresentation));
        }
    }

    public /* synthetic */ BsonModule(UuidRepresentation uuidRepresentation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uuidRepresentation = null;
        }
        this(uuidRepresentation);
    }

    @Override
    public void setupModule(@NotNull Module.SetupContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        super.setupModule(context);
        context.appendAnnotationIntrospector(KMongoAnnotationIntrospector.Companion.getINTROSPECTOR());
    }

    public BsonModule() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "T", "Lcom/willfp/eco/libs/litote/kmongo/Id;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "targetClass", "Lkotlin/reflect/KClass;", "", "(Lkotlin/reflect/KClass;)V", "getTargetClass", "()Lkotlin/reflect/KClass;", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Lorg/litote/kmongo/Id;", "kmongo-jackson-mapping"})
    @SourceDebugExtension(value={"SMAP\nBsonModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BsonModule.kt\norg/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,661:1\n1#2:662\n*E\n"})
    private static abstract class AbstractIdBsonDeserializer<T extends Id<?>>
    extends JsonDeserializer<T> {
        @NotNull
        private final KClass<? extends Object> targetClass;

        public AbstractIdBsonDeserializer(@NotNull KClass<? extends Object> targetClass) {
            Intrinsics.checkNotNullParameter(targetClass, "targetClass");
            this.targetClass = targetClass;
        }

        @NotNull
        public final KClass<? extends Object> getTargetClass() {
            return this.targetClass;
        }

        @Override
        @NotNull
        public T deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Id<?> id2;
            block5: {
                Id<?> id3;
                block7: {
                    Object it;
                    block6: {
                        block4: {
                            Intrinsics.checkNotNullParameter(jp, "jp");
                            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
                            if (jp.getCurrentToken() != JsonToken.VALUE_STRING) break block4;
                            String string = jp.getValueAsString();
                            Intrinsics.checkNotNullExpressionValue(string, "jp.valueAsString");
                            Id<?> id4 = IdTransformer.INSTANCE.wrapId(string);
                            id2 = id4;
                            Intrinsics.checkNotNull(id4, "null cannot be cast to non-null type T of org.litote.kmongo.jackson.BsonModule.AbstractIdBsonDeserializer");
                            break block5;
                        }
                        id3 = jp.getEmbeddedObject();
                        if (id3 == null) break block6;
                        it = id3;
                        boolean bl = false;
                        Id<?> id5 = IdTransformer.INSTANCE.wrapId(it);
                        id3 = id5;
                        if (id5 != null) break block7;
                    }
                    Class<KClass<? extends Object>> clazz = JvmClassMappingKt.getJavaClass(this.targetClass);
                    JsonToken jsonToken = jp.getCurrentToken();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonToken, "jp.currentToken");
                    it = StringDeserializationProblemHandler.INSTANCE.handleUnexpectedToken(ctxt, clazz, jsonToken, jp, "");
                    boolean bl = false;
                    if (Intrinsics.areEqual(it, DeserializationProblemHandler.NOT_HANDLED)) {
                        throw new IllegalStateException("not valid object found when trying to deserialize Id".toString());
                    }
                    id3 = it;
                }
                Id<?> id6 = id3;
                Intrinsics.checkNotNull(id6, "null cannot be cast to non-null type T of org.litote.kmongo.jackson.BsonModule.AbstractIdBsonDeserializer");
                id2 = id6;
            }
            return (T)id2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$BigDecimalBsonDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Ljava/math/BigDecimal;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BigDecimalBsonDeserializer
    extends JsonDeserializer<BigDecimal> {
        @NotNull
        public static final BigDecimalBsonDeserializer INSTANCE = new BigDecimalBsonDeserializer();

        private BigDecimalBsonDeserializer() {
        }

        @Override
        @NotNull
        public BigDecimal deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            BigDecimal bigDecimal;
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            if (jp.getCurrentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
                bigDecimal = new BigDecimal(jp.getDoubleValue());
            } else {
                BigDecimal bigDecimal2;
                Object v = jp.getEmbeddedObject();
                Object object = v;
                if (object instanceof Integer) {
                    Intrinsics.checkNotNullExpressionValue(v, "v");
                    bigDecimal2 = new BigDecimal(((Number)v).intValue());
                } else if (object instanceof Long) {
                    Intrinsics.checkNotNullExpressionValue(v, "v");
                    bigDecimal2 = new BigDecimal(((Number)v).longValue());
                } else if (object instanceof Float) {
                    bigDecimal2 = new BigDecimal(((Number)v).floatValue());
                } else if (object instanceof Double) {
                    Intrinsics.checkNotNullExpressionValue(v, "v");
                    bigDecimal2 = new BigDecimal(((Number)v).doubleValue());
                } else if (object instanceof Decimal128) {
                    bigDecimal2 = ((Decimal128)v).bigDecimalValue();
                } else if (object instanceof String) {
                    bigDecimal2 = new BigDecimal((String)v);
                } else {
                    throw new ClassCastException(v.getClass().getName() + " cannot be cast to " + BigDecimal.class.getName() + ": " + v);
                }
                BigDecimal bigDecimal3 = bigDecimal2;
                Intrinsics.checkNotNullExpressionValue(bigDecimal3, "{\n                val v \u2026          }\n            }");
                bigDecimal = bigDecimal3;
            }
            return bigDecimal;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$BigDecimalBsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Ljava/math/BigDecimal;", "()V", "serialize", "", "decimal", "generator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "provider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class BigDecimalBsonSerializer
    extends JsonSerializer<BigDecimal> {
        @NotNull
        public static final BigDecimalBsonSerializer INSTANCE = new BigDecimalBsonSerializer();

        private BigDecimalBsonSerializer() {
        }

        @Override
        public void serialize(@NotNull BigDecimal decimal, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter(decimal, "decimal");
            Intrinsics.checkNotNullParameter(generator, "generator");
            Intrinsics.checkNotNullParameter(provider, "provider");
            generator.writeNumber(decimal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$BinaryBsonDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Lcom/willfp/eco/libs/bson/types/Binary;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BinaryBsonDeserializer
    extends JsonDeserializer<Binary> {
        @NotNull
        public static final BinaryBsonDeserializer INSTANCE = new BinaryBsonDeserializer();

        private BinaryBsonDeserializer() {
        }

        @Override
        @NotNull
        public Binary deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            Object tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode treeNode = tree.get("$binary");
                Intrinsics.checkNotNull(treeNode, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                byte[] binary = Base64Variants.MIME_NO_LINEFEEDS.decode(((ValueNode)treeNode).asText());
                TreeNode treeNode2 = tree.get("$type");
                Intrinsics.checkNotNull(treeNode2, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                String string = ((ValueNode)treeNode2).asText();
                Intrinsics.checkNotNullExpressionValue(string, "tree.get(\"\\$type\") as ValueNode).asText()");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                byte type2 = (byte)Integer.valueOf(string2, 16).intValue();
                return new Binary(type2, binary);
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.Binary");
                return (Binary)object;
            }
            if (tree instanceof BinaryNode) {
                return new Binary(((BinaryNode)tree).binaryValue());
            }
            Object object = ctxt.handleUnexpectedToken(com.willfp.eco.libs.bson.types.ObjectId.class, jp);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.Binary");
            return (Binary)object;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$BinaryBsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/types/Binary;", "()V", "serialize", "", "obj", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class BinaryBsonSerializer
    extends JsonSerializer<Binary> {
        @NotNull
        public static final BinaryBsonSerializer INSTANCE = new BinaryBsonSerializer();

        private BinaryBsonSerializer() {
        }

        @Override
        public void serialize(@NotNull Binary obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeBinary(obj);
            } else {
                ExtendedJsonModule.BinaryExtendedJsonSerializer.INSTANCE.serialize(obj, gen, serializerProvider);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$BsonDateDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Ljava/util/Date;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    @SourceDebugExtension(value={"SMAP\nBsonModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BsonModule.kt\norg/litote/kmongo/jackson/BsonModule$BsonDateDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,661:1\n1#2:662\n*E\n"})
    private static final class BsonDateDeserializer
    extends JsonDeserializer<Date> {
        @NotNull
        public static final BsonDateDeserializer INSTANCE = new BsonDateDeserializer();

        private BsonDateDeserializer() {
        }

        @Override
        @NotNull
        public Date deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Date date;
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            if (jp instanceof BsonParser) {
                if (((BsonParser)jp).getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || ((BsonParser)jp).getCurrentBsonType() != 9) {
                    Object object = ctxt.handleUnexpectedToken(Date.class, jp);
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Throwable");
                    throw (Throwable)object;
                }
                Object object = ((BsonParser)jp).getEmbeddedObject();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type java.util.Date");
                return (Date)object;
            }
            Object object = jp.getEmbeddedObject();
            if (object != null) {
                Object it = object;
                boolean bl = false;
                date = (Date)it;
            } else {
                date = new Date(jp.getLongValue());
            }
            return date;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$BsonObjectIdDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Lcom/willfp/eco/libs/bson4jackson/types/ObjectId;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BsonObjectIdDeserializer
    extends JsonDeserializer<ObjectId> {
        @NotNull
        public static final BsonObjectIdDeserializer INSTANCE = new BsonObjectIdDeserializer();

        private BsonObjectIdDeserializer() {
        }

        @Override
        @NotNull
        public ObjectId deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            if (jp instanceof BsonParser) {
                if (((BsonParser)jp).getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || ((BsonParser)jp).getCurrentBsonType() != 7) {
                    JsonMappingException jsonMappingException = ctxt.mappingException(ObjectId.class);
                    Intrinsics.checkNotNullExpressionValue(jsonMappingException, "ctxt.mappingException(de\u2026pes.ObjectId::class.java)");
                    throw (Throwable)jsonMappingException;
                }
                Object object = ((BsonParser)jp).getEmbeddedObject();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type de.undercouch.bson4jackson.types.ObjectId");
                return (ObjectId)object;
            }
            Object tree = jp.getCodec().readTree(jp);
            TreeNode treeNode = tree.get("$time");
            Intrinsics.checkNotNull(treeNode, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
            int time = ((ValueNode)treeNode).asInt();
            TreeNode treeNode2 = tree.get("$machine");
            Intrinsics.checkNotNull(treeNode2, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
            int machine = ((ValueNode)treeNode2).asInt();
            TreeNode treeNode3 = tree.get("$inc");
            Intrinsics.checkNotNull(treeNode3, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
            int inc = ((ValueNode)treeNode3).asInt();
            return new KMongoObjectId(time, machine, inc);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$BsonTimestampBsonDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Lcom/willfp/eco/libs/bson/BsonTimestamp;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class BsonTimestampBsonDeserializer
    extends JsonDeserializer<BsonTimestamp> {
        @NotNull
        public static final BsonTimestampBsonDeserializer INSTANCE = new BsonTimestampBsonDeserializer();

        private BsonTimestampBsonDeserializer() {
        }

        @Override
        @NotNull
        public BsonTimestamp deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            Object tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode timestamp = tree.get("$timestamp");
                TreeNode treeNode = timestamp.get("t");
                Intrinsics.checkNotNull(treeNode, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                int time = ((ValueNode)treeNode).asInt();
                TreeNode treeNode2 = timestamp.get("i");
                Intrinsics.checkNotNull(treeNode2, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                int inc = ((ValueNode)treeNode2).asInt();
                return new BsonTimestamp(time, inc);
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.BsonTimestamp");
                return (BsonTimestamp)object;
            }
            Object object = ctxt.handleUnexpectedToken(BsonTimestamp.class, jp);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.BsonTimestamp");
            return (BsonTimestamp)object;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$BsonTimestampBsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/BsonTimestamp;", "()V", "serialize", "", "obj", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class BsonTimestampBsonSerializer
    extends JsonSerializer<BsonTimestamp> {
        @NotNull
        public static final BsonTimestampBsonSerializer INSTANCE = new BsonTimestampBsonSerializer();

        private BsonTimestampBsonSerializer() {
        }

        @Override
        public void serialize(@NotNull BsonTimestamp obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeBsonTimestamp(obj);
            } else {
                ExtendedJsonModule.BsonTimestampExtendedJsonSerializer.INSTANCE.serialize(obj, gen, serializerProvider);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$CalendarBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/util/Calendar;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class CalendarBsonDeserializer
    extends TemporalBsonDeserializer<Calendar> {
        @NotNull
        public static final CalendarBsonDeserializer INSTANCE = new CalendarBsonDeserializer();

        private CalendarBsonDeserializer() {
        }

        @Override
        @NotNull
        public Calendar toObject(@NotNull Date date) {
            Calendar calendar;
            Intrinsics.checkNotNullParameter(date, "date");
            Calendar $this$toObject_u24lambda_u240 = calendar = Calendar.getInstance(java.util.TimeZone.getTimeZone("UTC"));
            boolean bl = false;
            $this$toObject_u24lambda_u240.setTime(date);
            Calendar calendar2 = calendar;
            Intrinsics.checkNotNullExpressionValue(calendar2, "getInstance(TimeZone.get\u2026time = date\n            }");
            return calendar2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$CalendarBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/util/Calendar;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class CalendarBsonSerializer
    extends TemporalBsonSerializer<Calendar> {
        @NotNull
        public static final CalendarBsonSerializer INSTANCE = new CalendarBsonSerializer();

        private CalendarBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull Calendar temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.CalendarExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$Decimal128BsonDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Lcom/willfp/eco/libs/bson4jackson/types/Decimal128;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class Decimal128BsonDeserializer
    extends JsonDeserializer<Decimal128> {
        @NotNull
        public static final Decimal128BsonDeserializer INSTANCE = new Decimal128BsonDeserializer();

        private Decimal128BsonDeserializer() {
        }

        @Override
        @NotNull
        public Decimal128 deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            return new Decimal128(BigDecimalBsonDeserializer.INSTANCE.deserialize(jp, ctxt));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$Decimal128BsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson4jackson/types/Decimal128;", "()V", "serialize", "", "decimal", "generator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "provider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class Decimal128BsonSerializer
    extends JsonSerializer<Decimal128> {
        @NotNull
        public static final Decimal128BsonSerializer INSTANCE = new Decimal128BsonSerializer();

        private Decimal128BsonSerializer() {
        }

        @Override
        public void serialize(@NotNull Decimal128 decimal, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter(decimal, "decimal");
            Intrinsics.checkNotNullParameter(generator, "generator");
            Intrinsics.checkNotNullParameter(provider, "provider");
            BigDecimal bigDecimal = decimal.bigDecimalValue();
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "decimal.bigDecimalValue()");
            BigDecimalBsonSerializer.INSTANCE.serialize(bigDecimal, generator, provider);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$IdBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/Id;", "()V", "kmongo-jackson-mapping"})
    private static final class IdBsonDeserializer
    extends AbstractIdBsonDeserializer<Id<?>> {
        @NotNull
        public static final IdBsonDeserializer INSTANCE = new IdBsonDeserializer();

        private IdBsonDeserializer() {
            super(Reflection.getOrCreateKotlinClass(Id.class));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$IdBsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/Id;", "()V", "serialize", "", "id", "generator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "provider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class IdBsonSerializer
    extends JsonSerializer<Id<?>> {
        @NotNull
        public static final IdBsonSerializer INSTANCE = new IdBsonSerializer();

        private IdBsonSerializer() {
        }

        @Override
        public void serialize(@NotNull Id<?> id2, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Object object;
            Intrinsics.checkNotNullParameter(id2, "id");
            Intrinsics.checkNotNullParameter(generator, "generator");
            Intrinsics.checkNotNullParameter(provider, "provider");
            Object it = object = IdTransformer.INSTANCE.unwrapId(id2);
            boolean bl = false;
            Object object2 = it;
            if (object2 instanceof String) {
                generator.writeString((String)it);
            } else if (object2 instanceof com.willfp.eco.libs.bson.types.ObjectId) {
                ObjectIdBsonSerializer.INSTANCE.serialize((com.willfp.eco.libs.bson.types.ObjectId)it, generator, provider);
            } else {
                throw new IllegalStateException(("unsupported id type " + id2).toString());
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$InstantBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/Instant;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class InstantBsonDeserializer
    extends TemporalBsonDeserializer<Instant> {
        @NotNull
        public static final InstantBsonDeserializer INSTANCE = new InstantBsonDeserializer();

        private InstantBsonDeserializer() {
        }

        @Override
        @NotNull
        public Instant toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            Instant instant = date.toInstant();
            Intrinsics.checkNotNullExpressionValue(instant, "date.toInstant()");
            return instant;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$InstantBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/Instant;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class InstantBsonSerializer
    extends TemporalBsonSerializer<Instant> {
        @NotNull
        public static final InstantBsonSerializer INSTANCE = new InstantBsonSerializer();

        private InstantBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull Instant temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.InstantExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KMongoObjectId;", "Lcom/willfp/eco/libs/bson4jackson/types/ObjectId;", "time", "", "machine", "inc", "(III)V", "toString", "", "kmongo-jackson-mapping"})
    public static final class KMongoObjectId
    extends ObjectId {
        public KMongoObjectId(int time, int machine, int inc) {
            super(time, machine, inc);
        }

        @NotNull
        public String toString() {
            String string = KMongoBsonFactory.Companion.createFromLegacyFormat(this.getTime(), this.getMachine(), this.getInc()).toString();
            Intrinsics.checkNotNullExpressionValue(string, "createFromLegacyFormat(t\u2026 machine, inc).toString()");
            return string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u00020\u00052\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KPropertySerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lkotlin/reflect/KProperty;", "()V", "acceptJsonFormatVisitor", "", "visitor", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonFormatVisitorWrapper;", "type", "Lcom/willfp/eco/libs/jackson/databind/JavaType;", "serialize", "property", "generator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "provider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class KPropertySerializer
    extends JsonSerializer<KProperty<?>> {
        @NotNull
        public static final KPropertySerializer INSTANCE = new KPropertySerializer();

        private KPropertySerializer() {
        }

        @Override
        public void serialize(@NotNull KProperty<?> property, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(generator, "generator");
            Intrinsics.checkNotNullParameter(provider, "provider");
            generator.writeString(ProjectionsKt.getProjection(property));
        }

        @Override
        public void acceptJsonFormatVisitor(@NotNull JsonFormatVisitorWrapper visitor2, @NotNull JavaType type2) {
            Intrinsics.checkNotNullParameter(visitor2, "visitor");
            Intrinsics.checkNotNullParameter(type2, "type");
            visitor2.expectStringFormat(type2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KTXInstantBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Lkotlinx/datetime/Instant;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class KTXInstantBsonDeserializer
    extends TemporalBsonDeserializer<kotlinx.datetime.Instant> {
        @NotNull
        public static final KTXInstantBsonDeserializer INSTANCE = new KTXInstantBsonDeserializer();

        private KTXInstantBsonDeserializer() {
        }

        @Override
        @NotNull
        public kotlinx.datetime.Instant toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            return kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(date.toInstant().toEpochMilli());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KTXInstantBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Lkotlinx/datetime/Instant;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class KTXInstantBsonSerializer
    extends TemporalBsonSerializer<kotlinx.datetime.Instant> {
        @NotNull
        public static final KTXInstantBsonSerializer INSTANCE = new KTXInstantBsonSerializer();

        private KTXInstantBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.Instant temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.KTXInstantExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KTXLocalDateBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Lkotlinx/datetime/LocalDate;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class KTXLocalDateBsonDeserializer
    extends TemporalBsonDeserializer<kotlinx.datetime.LocalDate> {
        @NotNull
        public static final KTXLocalDateBsonDeserializer INSTANCE = new KTXLocalDateBsonDeserializer();

        private KTXLocalDateBsonDeserializer() {
        }

        @Override
        @NotNull
        public kotlinx.datetime.LocalDate toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(date.toInstant().toEpochMilli()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getDate();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KTXLocalDateBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Lkotlinx/datetime/LocalDate;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class KTXLocalDateBsonSerializer
    extends TemporalBsonSerializer<kotlinx.datetime.LocalDate> {
        @NotNull
        public static final KTXLocalDateBsonSerializer INSTANCE = new KTXLocalDateBsonSerializer();

        private KTXLocalDateBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.LocalDate temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.KTXLocalDateExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KTXLocalDateTimeBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Lkotlinx/datetime/LocalDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class KTXLocalDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<LocalDateTime> {
        @NotNull
        public static final KTXLocalDateTimeBsonDeserializer INSTANCE = new KTXLocalDateTimeBsonDeserializer();

        private KTXLocalDateTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public LocalDateTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(date.toInstant().toEpochMilli()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KTXLocalDateTimeBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Lkotlinx/datetime/LocalDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class KTXLocalDateTimeBsonSerializer
    extends TemporalBsonSerializer<LocalDateTime> {
        @NotNull
        public static final KTXLocalDateTimeBsonSerializer INSTANCE = new KTXLocalDateTimeBsonSerializer();

        private KTXLocalDateTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalDateTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.KTXLocalDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KTXLocalTimeBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Lkotlinx/datetime/LocalTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class KTXLocalTimeBsonDeserializer
    extends TemporalBsonDeserializer<LocalTime> {
        @NotNull
        public static final KTXLocalTimeBsonDeserializer INSTANCE = new KTXLocalTimeBsonDeserializer();

        private KTXLocalTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public LocalTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(date.toInstant().toEpochMilli()), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())).getTime();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$KTXLocalTimeBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Lkotlinx/datetime/LocalTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class KTXLocalTimeBsonSerializer
    extends TemporalBsonSerializer<LocalTime> {
        @NotNull
        public static final KTXLocalTimeBsonSerializer INSTANCE = new KTXLocalTimeBsonSerializer();

        private KTXLocalTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.KTXLocalTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$LocalDateBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalDate;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class LocalDateBsonDeserializer
    extends TemporalBsonDeserializer<LocalDate> {
        @NotNull
        public static final LocalDateBsonDeserializer INSTANCE = new LocalDateBsonDeserializer();

        private LocalDateBsonDeserializer() {
        }

        @Override
        @NotNull
        public LocalDate toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            LocalDate localDate = LocalDateTimeBsonDeserializer.INSTANCE.toObject(date).toLocalDate();
            Intrinsics.checkNotNullExpressionValue(localDate, "LocalDateTimeBsonDeseria\u2026bject(date).toLocalDate()");
            return localDate;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$LocalDateBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalDate;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class LocalDateBsonSerializer
    extends TemporalBsonSerializer<LocalDate> {
        @NotNull
        public static final LocalDateBsonSerializer INSTANCE = new LocalDateBsonSerializer();

        private LocalDateBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalDate temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.LocalDateExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$LocalDateTimeBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class LocalDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<java.time.LocalDateTime> {
        @NotNull
        public static final LocalDateTimeBsonDeserializer INSTANCE = new LocalDateTimeBsonDeserializer();

        private LocalDateTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public java.time.LocalDateTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            java.time.LocalDateTime localDateTime = java.time.LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue(localDateTime, "ofInstant(date.toInstant(), UTC)");
            return localDateTime;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$LocalDateTimeBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class LocalDateTimeBsonSerializer
    extends TemporalBsonSerializer<java.time.LocalDateTime> {
        @NotNull
        public static final LocalDateTimeBsonSerializer INSTANCE = new LocalDateTimeBsonSerializer();

        private LocalDateTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull java.time.LocalDateTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.LocalDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$LocalTimeBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/LocalTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class LocalTimeBsonDeserializer
    extends TemporalBsonDeserializer<java.time.LocalTime> {
        @NotNull
        public static final LocalTimeBsonDeserializer INSTANCE = new LocalTimeBsonDeserializer();

        private LocalTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public java.time.LocalTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            java.time.LocalTime localTime = LocalDateTimeBsonDeserializer.INSTANCE.toObject(date).toLocalTime();
            Intrinsics.checkNotNullExpressionValue(localTime, "LocalDateTimeBsonDeseria\u2026bject(date).toLocalTime()");
            return localTime;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$LocalTimeBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/LocalTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class LocalTimeBsonSerializer
    extends TemporalBsonSerializer<java.time.LocalTime> {
        @NotNull
        public static final LocalTimeBsonSerializer INSTANCE = new LocalTimeBsonSerializer();

        private LocalTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull java.time.LocalTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.LocalTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$MaxKeyBsonDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Lcom/willfp/eco/libs/bson/types/MaxKey;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class MaxKeyBsonDeserializer
    extends JsonDeserializer<MaxKey> {
        @NotNull
        public static final MaxKeyBsonDeserializer INSTANCE = new MaxKeyBsonDeserializer();

        private MaxKeyBsonDeserializer() {
        }

        @Override
        @NotNull
        public MaxKey deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            Object tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode treeNode = tree.get("$maxKey");
                Intrinsics.checkNotNull(treeNode, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                int value = ((ValueNode)treeNode).asInt();
                if (value == 1) {
                    return new MaxKey();
                }
                Object object = ctxt.handleUnexpectedToken(MaxKey.class, jp);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.MaxKey");
                return (MaxKey)object;
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.MaxKey");
                return (MaxKey)object;
            }
            if (tree instanceof TextNode) {
                return new MaxKey();
            }
            Object object = ctxt.handleUnexpectedToken(MaxKey.class, jp);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.MaxKey");
            return (MaxKey)object;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$MaxKeyBsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/types/MaxKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class MaxKeyBsonSerializer
    extends JsonSerializer<MaxKey> {
        @NotNull
        public static final MaxKeyBsonSerializer INSTANCE = new MaxKeyBsonSerializer();

        private MaxKeyBsonSerializer() {
        }

        @Override
        public void serialize(@NotNull MaxKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(jsonGenerator, "jsonGenerator");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            if (jsonGenerator instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)jsonGenerator).writeMaxKey();
            } else {
                ExtendedJsonModule.MaxKeyExtendedJsonSerializer.INSTANCE.serialize(obj, jsonGenerator, serializerProvider);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$MinKeyBsonDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Lcom/willfp/eco/libs/bson/types/MinKey;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class MinKeyBsonDeserializer
    extends JsonDeserializer<MinKey> {
        @NotNull
        public static final MinKeyBsonDeserializer INSTANCE = new MinKeyBsonDeserializer();

        private MinKeyBsonDeserializer() {
        }

        @Override
        @NotNull
        public MinKey deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            Object tree = jp.getCodec().readTree(jp);
            if (tree.isObject()) {
                TreeNode treeNode = tree.get("$minKey");
                Intrinsics.checkNotNull(treeNode, "null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ValueNode");
                int value = ((ValueNode)treeNode).asInt();
                if (value == 1) {
                    return new MinKey();
                }
                Object object = ctxt.handleUnexpectedToken(MinKey.class, jp);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.MinKey");
                return (MinKey)object;
            }
            if (tree instanceof POJONode) {
                Object object = ((POJONode)tree).getPojo();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.MinKey");
                return (MinKey)object;
            }
            if (tree instanceof TextNode) {
                return new MinKey();
            }
            Object object = ctxt.handleUnexpectedToken(MinKey.class, jp);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.MinKey");
            return (MinKey)object;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$MinKeyBsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/types/MinKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class MinKeyBsonSerializer
    extends JsonSerializer<MinKey> {
        @NotNull
        public static final MinKeyBsonSerializer INSTANCE = new MinKeyBsonSerializer();

        private MinKeyBsonSerializer() {
        }

        @Override
        public void serialize(@NotNull MinKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(jsonGenerator, "jsonGenerator");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            if (jsonGenerator instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)jsonGenerator).writeMinKey();
            } else {
                ExtendedJsonModule.MinKeyExtendedJsonSerializer.INSTANCE.serialize(obj, jsonGenerator, serializerProvider);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$ObjectIdBsonDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Lcom/willfp/eco/libs/bson/types/ObjectId;", "()V", "deserialize", "p", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class ObjectIdBsonDeserializer
    extends JsonDeserializer<com.willfp.eco.libs.bson.types.ObjectId> {
        @NotNull
        public static final ObjectIdBsonDeserializer INSTANCE = new ObjectIdBsonDeserializer();

        private ObjectIdBsonDeserializer() {
        }

        @Override
        @NotNull
        public com.willfp.eco.libs.bson.types.ObjectId deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            com.willfp.eco.libs.bson.types.ObjectId objectId;
            Intrinsics.checkNotNullParameter(p, "p");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            if (p instanceof BsonParser) {
                Object object = ((BsonParser)p).getEmbeddedObject();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.ObjectId");
                objectId = (com.willfp.eco.libs.bson.types.ObjectId)object;
            } else {
                Object t2 = p.getCodec().readTree(p);
                Intrinsics.checkNotNullExpressionValue(t2, "p.codec.readTree(p)");
                Object tree = t2;
                if (tree instanceof POJONode) {
                    Object object = ((POJONode)tree).getPojo();
                    Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bson.types.ObjectId");
                    objectId = (com.willfp.eco.libs.bson.types.ObjectId)object;
                } else {
                    TreeNode treeNode = tree.get("$oid");
                    Intrinsics.checkNotNull(treeNode, "null cannot be cast to non-null type com.fasterxml.jackson.databind.JsonNode");
                    objectId = new com.willfp.eco.libs.bson.types.ObjectId(((JsonNode)treeNode).textValue());
                }
            }
            return objectId;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$ObjectIdBsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/types/ObjectId;", "()V", "serialize", "", "objectId", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class ObjectIdBsonSerializer
    extends JsonSerializer<com.willfp.eco.libs.bson.types.ObjectId> {
        @NotNull
        public static final ObjectIdBsonSerializer INSTANCE = new ObjectIdBsonSerializer();

        private ObjectIdBsonSerializer() {
        }

        @Override
        public void serialize(@NotNull com.willfp.eco.libs.bson.types.ObjectId objectId, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(objectId, "objectId");
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                gen.writeObjectId(objectId);
            } else {
                ExtendedJsonModule.ObjectIdExtendedJsonSerializer.INSTANCE.serialize(objectId, gen, serializerProvider);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$OffsetDateTimeBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/OffsetDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class OffsetDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<OffsetDateTime> {
        @NotNull
        public static final OffsetDateTimeBsonDeserializer INSTANCE = new OffsetDateTimeBsonDeserializer();

        private OffsetDateTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public OffsetDateTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue(offsetDateTime, "ofInstant(date.toInstant(), UTC)");
            return offsetDateTime;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$OffsetDateTimeBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/OffsetDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class OffsetDateTimeBsonSerializer
    extends TemporalBsonSerializer<OffsetDateTime> {
        @NotNull
        public static final OffsetDateTimeBsonSerializer INSTANCE = new OffsetDateTimeBsonSerializer();

        private OffsetDateTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull OffsetDateTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.OffsetDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$OffsetTimeBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/OffsetTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class OffsetTimeBsonDeserializer
    extends TemporalBsonDeserializer<OffsetTime> {
        @NotNull
        public static final OffsetTimeBsonDeserializer INSTANCE = new OffsetTimeBsonDeserializer();

        private OffsetTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public OffsetTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            OffsetTime offsetTime = OffsetDateTimeBsonDeserializer.INSTANCE.toObject(date).toOffsetTime();
            Intrinsics.checkNotNullExpressionValue(offsetTime, "OffsetDateTimeBsonDeseri\u2026ject(date).toOffsetTime()");
            return offsetTime;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$OffsetTimeBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/OffsetTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class OffsetTimeBsonSerializer
    extends TemporalBsonSerializer<OffsetTime> {
        @NotNull
        public static final OffsetTimeBsonSerializer INSTANCE = new OffsetTimeBsonSerializer();

        private OffsetTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull OffsetTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.OffsetTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$StringIdBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/id/StringId;", "()V", "kmongo-jackson-mapping"})
    private static final class StringIdBsonDeserializer
    extends AbstractIdBsonDeserializer<StringId<?>> {
        @NotNull
        public static final StringIdBsonDeserializer INSTANCE = new StringIdBsonDeserializer();

        private StringIdBsonDeserializer() {
            super(Reflection.getOrCreateKotlinClass(String.class));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "T", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Ljava/lang/Object;", "toObject", "date", "Ljava/util/Date;", "(Ljava/util/Date;)Ljava/lang/Object;", "kmongo-jackson-mapping"})
    private static abstract class TemporalBsonDeserializer<T>
    extends JsonDeserializer<T> {
        /*
         * WARNING - void declaration
         */
        @Override
        public T deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            void $this$deserialize_u24lambda_u240;
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            Object object = jp.getEmbeddedObject();
            TemporalBsonDeserializer temporalBsonDeserializer = this;
            boolean bl = false;
            return temporalBsonDeserializer.toObject($this$deserialize_u24lambda_u240 == null ? new Date(jp.getLongValue()) : (Date)$this$deserialize_u24lambda_u240);
        }

        public abstract T toObject(@NotNull Date var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nJ%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "T", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "()V", "date", "Ljava/util/Date;", "temporal", "(Ljava/lang/Object;)Ljava/util/Date;", "epochMillis", "", "(Ljava/lang/Object;)J", "serialize", "", "value", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "kmongo-jackson-mapping"})
    private static abstract class TemporalBsonSerializer<T>
    extends JsonSerializer<T> {
        @Override
        public void serialize(T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            if (gen instanceof KMongoBsonFactory.KMongoBsonGenerator) {
                ((KMongoBsonFactory.KMongoBsonGenerator)gen).writeDateTime(this.date(value));
            } else {
                ExtendedJsonModule.DateExtendedJsonSerializer.INSTANCE.serialize(this.date(value), gen, serializerProvider);
            }
        }

        @NotNull
        public final Date date(T temporal) {
            return new Date(this.epochMillis(temporal));
        }

        public abstract long epochMillis(T var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$UuidDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Ljava/util/UUID;", "uuidRepresentation", "Lcom/willfp/eco/libs/bson/UuidRepresentation;", "(Lorg/bson/UuidRepresentation;)V", "binaryType", "", "deserialize", "p", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    public static final class UuidDeserializer
    extends JsonDeserializer<UUID> {
        @NotNull
        private final UuidRepresentation uuidRepresentation;
        private final byte binaryType;

        public UuidDeserializer(@NotNull UuidRepresentation uuidRepresentation) {
            Intrinsics.checkNotNullParameter((Object)uuidRepresentation, "uuidRepresentation");
            this.uuidRepresentation = uuidRepresentation;
            this.binaryType = this.uuidRepresentation == UuidRepresentation.STANDARD ? BsonBinarySubType.UUID_STANDARD.getValue() : BsonBinarySubType.UUID_LEGACY.getValue();
        }

        @Override
        @NotNull
        public UUID deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            UUID uUID;
            byte[] bytes;
            Intrinsics.checkNotNullParameter(p, "p");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            Object object = p.getEmbeddedObject();
            byte[] byArray = bytes = object instanceof byte[] ? (byte[])object : null;
            if (p.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && bytes != null) {
                UUID uUID2 = UuidHelper.decodeBinaryToUuid(bytes, this.binaryType, this.uuidRepresentation);
                uUID = uUID2;
                Intrinsics.checkNotNullExpressionValue(uUID2, "{\n                UuidHe\u2026esentation)\n            }");
            } else {
                Object t2 = new UUIDDeserializer().deserialize(p, ctxt);
                Intrinsics.checkNotNullExpressionValue(t2, "{\n                UUIDDe\u2026ze(p, ctxt)\n            }");
                uUID = (UUID)t2;
            }
            return uUID;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$UuidSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Ljava/util/UUID;", "uuidRepresentation", "Lcom/willfp/eco/libs/bson/UuidRepresentation;", "(Lorg/bson/UuidRepresentation;)V", "binaryType", "", "serialize", "", "value", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializers", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class UuidSerializer
    extends JsonSerializer<UUID> {
        @NotNull
        private final UuidRepresentation uuidRepresentation;
        private final byte binaryType;

        public UuidSerializer(@NotNull UuidRepresentation uuidRepresentation) {
            Intrinsics.checkNotNullParameter((Object)uuidRepresentation, "uuidRepresentation");
            this.uuidRepresentation = uuidRepresentation;
            this.binaryType = this.uuidRepresentation == UuidRepresentation.STANDARD ? BsonBinarySubType.UUID_STANDARD.getValue() : BsonBinarySubType.UUID_LEGACY.getValue();
        }

        @Override
        public void serialize(@NotNull UUID value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializers, "serializers");
            if (gen instanceof BsonGenerator) {
                ((BsonGenerator)gen).writeBinary(null, this.binaryType, UuidHelper.encodeUuidToBinary(value, this.uuidRepresentation), 0, 16);
            } else {
                new UUIDSerializer().serialize(value, gen, serializers);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$WrappedObjectIdBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$AbstractIdBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/id/WrappedObjectId;", "()V", "kmongo-jackson-mapping"})
    private static final class WrappedObjectIdBsonDeserializer
    extends AbstractIdBsonDeserializer<WrappedObjectId<?>> {
        @NotNull
        public static final WrappedObjectIdBsonDeserializer INSTANCE = new WrappedObjectIdBsonDeserializer();

        private WrappedObjectIdBsonDeserializer() {
            super(Reflection.getOrCreateKotlinClass(Id.class));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$ZoneIdBsonDeserializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonDeserializer;", "Ljava/time/ZoneId;", "()V", "deserialize", "jp", "Lcom/willfp/eco/libs/jackson/core/JsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/databind/DeserializationContext;", "kmongo-jackson-mapping"})
    private static final class ZoneIdBsonDeserializer
    extends JsonDeserializer<ZoneId> {
        @NotNull
        public static final ZoneIdBsonDeserializer INSTANCE = new ZoneIdBsonDeserializer();

        private ZoneIdBsonDeserializer() {
        }

        @Override
        @NotNull
        public ZoneId deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext ctxt) {
            Intrinsics.checkNotNullParameter(jp, "jp");
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            ZoneId zoneId = ZoneId.of(jp.getValueAsString());
            Intrinsics.checkNotNullExpressionValue(zoneId, "of(jp.valueAsString)");
            return zoneId;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$ZoneIdBsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Ljava/time/ZoneId;", "()V", "serialize", "", "obj", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class ZoneIdBsonSerializer
    extends JsonSerializer<ZoneId> {
        @NotNull
        public static final ZoneIdBsonSerializer INSTANCE = new ZoneIdBsonSerializer();

        private ZoneIdBsonSerializer() {
        }

        @Override
        public void serialize(@NotNull ZoneId obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            gen.writeString(obj.toString());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$ZonedDateTimeBsonDeserializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonDeserializer;", "Ljava/time/ZonedDateTime;", "()V", "toObject", "date", "Ljava/util/Date;", "kmongo-jackson-mapping"})
    private static final class ZonedDateTimeBsonDeserializer
    extends TemporalBsonDeserializer<ZonedDateTime> {
        @NotNull
        public static final ZonedDateTimeBsonDeserializer INSTANCE = new ZonedDateTimeBsonDeserializer();

        private ZonedDateTimeBsonDeserializer() {
        }

        @Override
        @NotNull
        public ZonedDateTime toObject(@NotNull Date date) {
            Intrinsics.checkNotNullParameter(date, "date");
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue(zonedDateTime, "ofInstant(date.toInstant(), UTC)");
            return zonedDateTime;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$ZonedDateTimeBsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/BsonModule$TemporalBsonSerializer;", "Ljava/time/ZonedDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    private static final class ZonedDateTimeBsonSerializer
    extends TemporalBsonSerializer<ZonedDateTime> {
        @NotNull
        public static final ZonedDateTimeBsonSerializer INSTANCE = new ZonedDateTimeBsonSerializer();

        private ZonedDateTimeBsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull ZonedDateTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return ExtendedJsonModule.ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(temporal);
        }
    }
}

