/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.litote.kmongo.jackson;

import com.willfp.eco.libs.bson.BsonTimestamp;
import com.willfp.eco.libs.bson.types.Binary;
import com.willfp.eco.libs.bson.types.MaxKey;
import com.willfp.eco.libs.bson.types.MinKey;
import com.willfp.eco.libs.bson.types.ObjectId;
import com.willfp.eco.libs.jackson.core.JsonGenerator;
import com.willfp.eco.libs.jackson.databind.JsonSerializer;
import com.willfp.eco.libs.jackson.databind.Module;
import com.willfp.eco.libs.jackson.databind.SerializerProvider;
import com.willfp.eco.libs.jackson.databind.module.SimpleModule;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.litote.kmongo.Id;
import com.willfp.eco.libs.litote.kmongo.id.IdTransformer;
import com.willfp.eco.libs.litote.kmongo.id.jackson.IdKeySerializer;
import com.willfp.eco.libs.litote.kmongo.jackson.KMongoAnnotationIntrospector;
import com.willfp.eco.libs.litote.kmongo.util.KotlinxDatetimeLoader;
import com.willfp.eco.libs.litote.kmongo.util.PatternUtil;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.LocalTimeKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0000\u0018\u00002\u00020\u0001:\u0017\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001e"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule;", "Lcom/willfp/eco/libs/jackson/databind/module/SimpleModule;", "()V", "setupModule", "", "context", "Lcom/willfp/eco/libs/jackson/databind/Module$SetupContext;", "BigDecimalSerializer", "BinaryExtendedJsonSerializer", "BsonTimestampExtendedJsonSerializer", "CalendarExtendedJsonSerializer", "DateExtendedJsonSerializer", "IdSerializer", "InstantExtendedJsonSerializer", "KTXInstantExtendedJsonSerializer", "KTXLocalDateExtendedJsonSerializer", "KTXLocalDateTimeExtendedJsonSerializer", "KTXLocalTimeExtendedJsonSerializer", "LocalDateExtendedJsonSerializer", "LocalDateTimeExtendedJsonSerializer", "LocalTimeExtendedJsonSerializer", "MaxKeyExtendedJsonSerializer", "MinKeyExtendedJsonSerializer", "ObjectIdExtendedJsonSerializer", "OffsetDateTimeExtendedJsonSerializer", "OffsetTimeExtendedJsonSerializer", "PatternSerializer", "RegexSerializer", "TemporalExtendedJsonSerializer", "ZonedDateTimeExtendedJsonSerializer", "kmongo-jackson-mapping"})
public final class ExtendedJsonModule
extends SimpleModule {
    public ExtendedJsonModule() {
        this.addSerializer(ObjectId.class, ObjectIdExtendedJsonSerializer.INSTANCE);
        this.addSerializer(Binary.class, BinaryExtendedJsonSerializer.INSTANCE);
        this.addSerializer(BsonTimestamp.class, BsonTimestampExtendedJsonSerializer.INSTANCE);
        this.addSerializer(MaxKey.class, MaxKeyExtendedJsonSerializer.INSTANCE);
        this.addSerializer(MinKey.class, MinKeyExtendedJsonSerializer.INSTANCE);
        this.addSerializer(BigDecimal.class, BigDecimalSerializer.INSTANCE);
        this.addSerializer(Id.class, IdSerializer.INSTANCE);
        this.addKeySerializer(Id.class, new IdKeySerializer());
        this.addSerializer(Date.class, DateExtendedJsonSerializer.INSTANCE);
        this.addSerializer(Calendar.class, CalendarExtendedJsonSerializer.INSTANCE);
        this.addSerializer(Instant.class, InstantExtendedJsonSerializer.INSTANCE);
        this.addSerializer(ZonedDateTime.class, ZonedDateTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(OffsetDateTime.class, OffsetDateTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(LocalDate.class, LocalDateExtendedJsonSerializer.INSTANCE);
        this.addSerializer(LocalDateTime.class, LocalDateTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(java.time.LocalTime.class, LocalTimeExtendedJsonSerializer.INSTANCE);
        this.addSerializer(OffsetTime.class, OffsetTimeExtendedJsonSerializer.INSTANCE);
        KotlinxDatetimeLoader.INSTANCE.loadKotlinxDateTime((Function0)new Function0<Object>(){

            @Override
            public final Object invoke() {
                this.addSerializer(kotlinx.datetime.Instant.class, KTXInstantExtendedJsonSerializer.INSTANCE);
                this.addSerializer(kotlinx.datetime.LocalDate.class, KTXLocalDateExtendedJsonSerializer.INSTANCE);
                this.addSerializer(kotlinx.datetime.LocalDateTime.class, KTXLocalDateTimeExtendedJsonSerializer.INSTANCE);
                return this.addSerializer(LocalTime.class, KTXLocalTimeExtendedJsonSerializer.INSTANCE);
            }
        }, 2.INSTANCE);
        this.addSerializer(Pattern.class, PatternSerializer.INSTANCE);
        this.addSerializer(Regex.class, RegexSerializer.INSTANCE);
    }

    @Override
    public void setupModule(@NotNull Module.SetupContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        super.setupModule(context);
        context.appendAnnotationIntrospector(KMongoAnnotationIntrospector.Companion.getINTROSPECTOR());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$BigDecimalSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Ljava/math/BigDecimal;", "()V", "serialize", "", "bigDecimal", "generator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "provider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class BigDecimalSerializer
    extends JsonSerializer<BigDecimal> {
        @NotNull
        public static final BigDecimalSerializer INSTANCE = new BigDecimalSerializer();

        private BigDecimalSerializer() {
        }

        @Override
        public void serialize(@NotNull BigDecimal bigDecimal, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter(bigDecimal, "bigDecimal");
            Intrinsics.checkNotNullParameter(generator, "generator");
            Intrinsics.checkNotNullParameter(provider, "provider");
            generator.writeStartObject();
            generator.writeStringField("$numberDecimal", bigDecimal.toString());
            generator.writeEndObject();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$BinaryExtendedJsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/types/Binary;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class BinaryExtendedJsonSerializer
    extends JsonSerializer<Binary> {
        @NotNull
        public static final BinaryExtendedJsonSerializer INSTANCE = new BinaryExtendedJsonSerializer();

        private BinaryExtendedJsonSerializer() {
        }

        @Override
        public void serialize(@NotNull Binary obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(jsonGenerator, "jsonGenerator");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeBinaryField("$binary", obj.getData());
            String string = Integer.toHexString(obj.getType());
            Intrinsics.checkNotNullExpressionValue(string, "toHexString(obj.type.toInt())");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase(Locale.ROOT)");
            jsonGenerator.writeStringField("$type", string2);
            jsonGenerator.writeEndObject();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$BsonTimestampExtendedJsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/BsonTimestamp;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class BsonTimestampExtendedJsonSerializer
    extends JsonSerializer<BsonTimestamp> {
        @NotNull
        public static final BsonTimestampExtendedJsonSerializer INSTANCE = new BsonTimestampExtendedJsonSerializer();

        private BsonTimestampExtendedJsonSerializer() {
        }

        @Override
        public void serialize(@NotNull BsonTimestamp obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(jsonGenerator, "jsonGenerator");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName("$timestamp");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("t", obj.getTime());
            jsonGenerator.writeNumberField("i", obj.getInc());
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$CalendarExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/util/Calendar;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class CalendarExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<Calendar> {
        @NotNull
        public static final CalendarExtendedJsonSerializer INSTANCE = new CalendarExtendedJsonSerializer();

        private CalendarExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull Calendar temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return temporal.getTimeInMillis();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$DateExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/util/Date;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class DateExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<Date> {
        @NotNull
        public static final DateExtendedJsonSerializer INSTANCE = new DateExtendedJsonSerializer();

        private DateExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull Date temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return temporal.getTime();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$IdSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/Id;", "()V", "serialize", "", "id", "generator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "provider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class IdSerializer
    extends JsonSerializer<Id<?>> {
        @NotNull
        public static final IdSerializer INSTANCE = new IdSerializer();

        private IdSerializer() {
        }

        @Override
        public void serialize(@NotNull Id<?> id2, @NotNull JsonGenerator generator, @NotNull SerializerProvider provider) {
            Intrinsics.checkNotNullParameter(id2, "id");
            Intrinsics.checkNotNullParameter(generator, "generator");
            Intrinsics.checkNotNullParameter(provider, "provider");
            generator.writeObject(IdTransformer.INSTANCE.unwrapId(id2));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$InstantExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/Instant;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class InstantExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<Instant> {
        @NotNull
        public static final InstantExtendedJsonSerializer INSTANCE = new InstantExtendedJsonSerializer();

        private InstantExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull Instant temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return temporal.toEpochMilli();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$KTXInstantExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Lkotlinx/datetime/Instant;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class KTXInstantExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<kotlinx.datetime.Instant> {
        @NotNull
        public static final KTXInstantExtendedJsonSerializer INSTANCE = new KTXInstantExtendedJsonSerializer();

        private KTXInstantExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.Instant temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return temporal.toEpochMilliseconds();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$KTXLocalDateExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Lkotlinx/datetime/LocalDate;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class KTXLocalDateExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<kotlinx.datetime.LocalDate> {
        @NotNull
        public static final KTXLocalDateExtendedJsonSerializer INSTANCE = new KTXLocalDateExtendedJsonSerializer();

        private KTXLocalDateExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.LocalDate temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return KTXInstantExtendedJsonSerializer.INSTANCE.epochMillis(TimeZoneKt.atStartOfDayIn((kotlinx.datetime.LocalDate)temporal, (TimeZone)((TimeZone)TimeZone.Companion.getUTC())));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$KTXLocalDateTimeExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Lkotlinx/datetime/LocalDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class KTXLocalDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<kotlinx.datetime.LocalDateTime> {
        @NotNull
        public static final KTXLocalDateTimeExtendedJsonSerializer INSTANCE = new KTXLocalDateTimeExtendedJsonSerializer();

        private KTXLocalDateTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull kotlinx.datetime.LocalDateTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return KTXInstantExtendedJsonSerializer.INSTANCE.epochMillis(TimeZoneKt.toInstant((kotlinx.datetime.LocalDateTime)temporal, (TimeZone)((TimeZone)TimeZone.Companion.getUTC())));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$KTXLocalTimeExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Lkotlinx/datetime/LocalTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class KTXLocalTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<LocalTime> {
        @NotNull
        public static final KTXLocalTimeExtendedJsonSerializer INSTANCE = new KTXLocalTimeExtendedJsonSerializer();

        private KTXLocalTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            return KTXInstantExtendedJsonSerializer.INSTANCE.epochMillis(TimeZoneKt.toInstant((kotlinx.datetime.LocalDateTime)LocalTimeKt.atDate((LocalTime)temporal, (kotlinx.datetime.LocalDate)kotlinx.datetime.LocalDate.Companion.fromEpochDays(0)), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$LocalDateExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/LocalDate;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class LocalDateExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<LocalDate> {
        @NotNull
        public static final LocalDateExtendedJsonSerializer INSTANCE = new LocalDateExtendedJsonSerializer();

        private LocalDateExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalDate temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            ZonedDateTime zonedDateTime = temporal.atStartOfDay(ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue(zonedDateTime, "temporal.atStartOfDay(UTC)");
            return ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(zonedDateTime);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$LocalDateTimeExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/LocalDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class LocalDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<LocalDateTime> {
        @NotNull
        public static final LocalDateTimeExtendedJsonSerializer INSTANCE = new LocalDateTimeExtendedJsonSerializer();

        private LocalDateTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull LocalDateTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            ZonedDateTime zonedDateTime = temporal.atZone(ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue(zonedDateTime, "temporal.atZone(UTC)");
            return ZonedDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(zonedDateTime);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$LocalTimeExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/LocalTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class LocalTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<java.time.LocalTime> {
        @NotNull
        public static final LocalTimeExtendedJsonSerializer INSTANCE = new LocalTimeExtendedJsonSerializer();

        private LocalTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull java.time.LocalTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            LocalDateTime localDateTime = temporal.atDate(LocalDate.ofEpochDay(0L));
            Intrinsics.checkNotNullExpressionValue(localDateTime, "temporal.atDate(LocalDate.ofEpochDay(0))");
            return LocalDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(localDateTime);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$MaxKeyExtendedJsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/types/MaxKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class MaxKeyExtendedJsonSerializer
    extends JsonSerializer<MaxKey> {
        @NotNull
        public static final MaxKeyExtendedJsonSerializer INSTANCE = new MaxKeyExtendedJsonSerializer();

        private MaxKeyExtendedJsonSerializer() {
        }

        @Override
        public void serialize(@NotNull MaxKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(jsonGenerator, "jsonGenerator");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("$maxKey", 1);
            jsonGenerator.writeEndObject();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$MinKeyExtendedJsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/types/MinKey;", "()V", "serialize", "", "obj", "jsonGenerator", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class MinKeyExtendedJsonSerializer
    extends JsonSerializer<MinKey> {
        @NotNull
        public static final MinKeyExtendedJsonSerializer INSTANCE = new MinKeyExtendedJsonSerializer();

        private MinKeyExtendedJsonSerializer() {
        }

        @Override
        public void serialize(@NotNull MinKey obj, @NotNull JsonGenerator jsonGenerator, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(jsonGenerator, "jsonGenerator");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("$minKey", 1);
            jsonGenerator.writeEndObject();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$ObjectIdExtendedJsonSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lcom/willfp/eco/libs/bson/types/ObjectId;", "()V", "serialize", "", "value", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializers", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    public static final class ObjectIdExtendedJsonSerializer
    extends JsonSerializer<ObjectId> {
        @NotNull
        public static final ObjectIdExtendedJsonSerializer INSTANCE = new ObjectIdExtendedJsonSerializer();

        private ObjectIdExtendedJsonSerializer() {
        }

        @Override
        public void serialize(@NotNull ObjectId value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializers, "serializers");
            gen.writeStartObject();
            gen.writeStringField("$oid", value.toHexString());
            gen.writeEndObject();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$OffsetDateTimeExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/OffsetDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class OffsetDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<OffsetDateTime> {
        @NotNull
        public static final OffsetDateTimeExtendedJsonSerializer INSTANCE = new OffsetDateTimeExtendedJsonSerializer();

        private OffsetDateTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull OffsetDateTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            Instant instant = temporal.toInstant();
            Intrinsics.checkNotNullExpressionValue(instant, "temporal.toInstant()");
            return InstantExtendedJsonSerializer.INSTANCE.epochMillis(instant);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$OffsetTimeExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/OffsetTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class OffsetTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<OffsetTime> {
        @NotNull
        public static final OffsetTimeExtendedJsonSerializer INSTANCE = new OffsetTimeExtendedJsonSerializer();

        private OffsetTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull OffsetTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            OffsetDateTime offsetDateTime = temporal.atDate(LocalDate.ofEpochDay(0L));
            Intrinsics.checkNotNullExpressionValue(offsetDateTime, "temporal.atDate(LocalDate.ofEpochDay(0))");
            return OffsetDateTimeExtendedJsonSerializer.INSTANCE.epochMillis(offsetDateTime);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$PatternSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Ljava/util/regex/Pattern;", "()V", "serialize", "", "obj", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class PatternSerializer
    extends JsonSerializer<Pattern> {
        @NotNull
        public static final PatternSerializer INSTANCE = new PatternSerializer();

        private PatternSerializer() {
        }

        @Override
        public void serialize(@NotNull Pattern obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            gen.writeStartObject();
            gen.writeStringField("$regex", obj.pattern());
            gen.writeStringField("$options", PatternUtil.INSTANCE.getOptionsAsString(obj));
            gen.writeEndObject();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$RegexSerializer;", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "Lkotlin/text/Regex;", "()V", "serialize", "", "obj", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializerProvider", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "kmongo-jackson-mapping"})
    private static final class RegexSerializer
    extends JsonSerializer<Regex> {
        @NotNull
        public static final RegexSerializer INSTANCE = new RegexSerializer();

        private RegexSerializer() {
        }

        @Override
        public void serialize(@NotNull Regex obj, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializerProvider) {
            Intrinsics.checkNotNullParameter(obj, "obj");
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializerProvider, "serializerProvider");
            PatternSerializer.INSTANCE.serialize(obj.toPattern(), gen, serializerProvider);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0007J%\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "T", "Lcom/willfp/eco/libs/jackson/databind/JsonSerializer;", "()V", "epochMillis", "", "temporal", "(Ljava/lang/Object;)J", "serialize", "", "value", "gen", "Lcom/willfp/eco/libs/jackson/core/JsonGenerator;", "serializers", "Lcom/willfp/eco/libs/jackson/databind/SerializerProvider;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "kmongo-jackson-mapping"})
    public static abstract class TemporalExtendedJsonSerializer<T>
    extends JsonSerializer<T> {
        @Override
        public void serialize(T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter(gen, "gen");
            Intrinsics.checkNotNullParameter(serializers, "serializers");
            gen.writeStartObject();
            gen.writeNumberField("$date", this.epochMillis(value));
            gen.writeEndObject();
        }

        public abstract long epochMillis(T var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$ZonedDateTimeExtendedJsonSerializer;", "Lcom/willfp/eco/libs/litote/kmongo/jackson/ExtendedJsonModule$TemporalExtendedJsonSerializer;", "Ljava/time/ZonedDateTime;", "()V", "epochMillis", "", "temporal", "kmongo-jackson-mapping"})
    public static final class ZonedDateTimeExtendedJsonSerializer
    extends TemporalExtendedJsonSerializer<ZonedDateTime> {
        @NotNull
        public static final ZonedDateTimeExtendedJsonSerializer INSTANCE = new ZonedDateTimeExtendedJsonSerializer();

        private ZonedDateTimeExtendedJsonSerializer() {
        }

        @Override
        public long epochMillis(@NotNull ZonedDateTime temporal) {
            Intrinsics.checkNotNullParameter(temporal, "temporal");
            Instant instant = temporal.toInstant();
            Intrinsics.checkNotNullExpressionValue(instant, "temporal.toInstant()");
            return InstantExtendedJsonSerializer.INSTANCE.epochMillis(instant);
        }
    }
}

