/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.litote.kmongo.jackson;

import com.willfp.eco.libs.bson.BsonBinaryWriter;
import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.RawBsonDocument;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.CollectibleCodec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.io.BasicOutputBuffer;
import com.willfp.eco.libs.bson.json.JsonReader;
import com.willfp.eco.libs.jackson.databind.JavaType;
import com.willfp.eco.libs.jackson.databind.ObjectMapper;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.libs.litote.kmongo.Id;
import com.willfp.eco.libs.litote.kmongo.SharedExtensionsKt;
import com.willfp.eco.libs.litote.kmongo.id.StringId;
import com.willfp.eco.libs.litote.kmongo.jackson.JacksonCodec;
import com.willfp.eco.libs.litote.kmongo.util.KMongoUtil;
import com.willfp.eco.libs.litote.kmongo.util.KotlinxDatetimeLoader;
import com.willfp.eco.libs.litote.kmongo.util.MongoIdUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.jvm.ReflectJvmMapping;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001)B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/JacksonCodec;", "T", "", "Lcom/willfp/eco/libs/bson/codecs/Codec;", "Lcom/willfp/eco/libs/bson/codecs/CollectibleCodec;", "bsonObjectMapper", "Lcom/willfp/eco/libs/jackson/databind/ObjectMapper;", "notBsonObjectMapper", "codecRegistry", "Lcom/willfp/eco/libs/bson/codecs/configuration/CodecRegistry;", "type", "Ljava/lang/Class;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/bson/codecs/configuration/CodecRegistry;Ljava/lang/Class;)V", "rawBsonDocumentCodec", "Lcom/willfp/eco/libs/bson/RawBsonDocument;", "getType", "()Ljava/lang/Class;", "decode", "reader", "Lcom/willfp/eco/libs/bson/BsonReader;", "decoderContext", "Lcom/willfp/eco/libs/bson/codecs/DecoderContext;", "(Lorg/bson/BsonReader;Lorg/bson/codecs/DecoderContext;)Ljava/lang/Object;", "documentHasId", "", "document", "(Ljava/lang/Object;)Z", "encode", "", "writer", "Lcom/willfp/eco/libs/bson/BsonWriter;", "value", "encoderContext", "Lcom/willfp/eco/libs/bson/codecs/EncoderContext;", "(Lorg/bson/BsonWriter;Ljava/lang/Object;Lorg/bson/codecs/EncoderContext;)V", "generateIdIfAbsentFromDocument", "(Ljava/lang/Object;)Ljava/lang/Object;", "getDocumentId", "Lcom/willfp/eco/libs/bson/BsonValue;", "(Ljava/lang/Object;)Lorg/bson/BsonValue;", "getEncoderClass", "VisitorWrapper", "kmongo-jackson-mapping"})
@SourceDebugExtension(value={"SMAP\nJacksonCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JacksonCodec.kt\norg/litote/kmongo/jackson/JacksonCodec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
public final class JacksonCodec<T>
implements Codec<T>,
CollectibleCodec<T> {
    @NotNull
    private final ObjectMapper bsonObjectMapper;
    @NotNull
    private final ObjectMapper notBsonObjectMapper;
    @NotNull
    private final Class<T> type;
    @NotNull
    private final Codec<RawBsonDocument> rawBsonDocumentCodec;

    public JacksonCodec(@NotNull ObjectMapper bsonObjectMapper, @NotNull ObjectMapper notBsonObjectMapper, @NotNull CodecRegistry codecRegistry, @NotNull Class<T> type2) {
        Intrinsics.checkNotNullParameter(bsonObjectMapper, "bsonObjectMapper");
        Intrinsics.checkNotNullParameter(notBsonObjectMapper, "notBsonObjectMapper");
        Intrinsics.checkNotNullParameter(codecRegistry, "codecRegistry");
        Intrinsics.checkNotNullParameter(type2, "type");
        this.bsonObjectMapper = bsonObjectMapper;
        this.notBsonObjectMapper = notBsonObjectMapper;
        this.type = type2;
        Codec<RawBsonDocument> codec = codecRegistry.get(RawBsonDocument.class);
        Intrinsics.checkNotNullExpressionValue(codec, "codecRegistry.get(RawBsonDocument::class.java)");
        this.rawBsonDocumentCodec = codec;
    }

    @NotNull
    public final Class<T> getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T decode(@NotNull BsonReader reader, @NotNull DecoderContext decoderContext) {
        T t2;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(decoderContext, "decoderContext");
        if (reader.getCurrentBsonType() == BsonType.STRING) {
            String s2 = reader.readString();
            Intrinsics.checkNotNullExpressionValue(s2, "s");
            return this.notBsonObjectMapper.readValue(SharedExtensionsKt.getJson(s2), this.type);
        }
        BasicOutputBuffer buffer = new BasicOutputBuffer(128);
        BsonBinaryWriter writer = new BsonBinaryWriter(buffer);
        try {
            writer.pipe(reader);
            t2 = this.bsonObjectMapper.readValue(buffer.getInternalBuffer(), this.type);
        }
        finally {
            writer.close();
            buffer.close();
        }
        return t2;
    }

    @Override
    public void encode(@NotNull BsonWriter writer, @Nullable T value, @NotNull EncoderContext encoderContext) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(encoderContext, "encoderContext");
        try {
            if (value == null) {
                writer.writeNull();
            } else {
                VisitorWrapper visitor2 = new VisitorWrapper();
                this.bsonObjectMapper.acceptJsonFormatVisitor(value.getClass(), (JsonFormatVisitorWrapper)visitor2);
                VisitorWrapper.JsonType jsonType = visitor2.getJsonType();
                block1 : switch (jsonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonType.ordinal()]) {
                    case -1: 
                    case 6: 
                    case 7: 
                    case 8: {
                        byte[] bytes = this.bsonObjectMapper.writeValueAsBytes(value);
                        this.rawBsonDocumentCodec.encode(writer, new RawBsonDocument(bytes), encoderContext);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: {
                        JsonReader jsonReader = new JsonReader(this.notBsonObjectMapper.writeValueAsString(value));
                        BsonType bsonType = jsonReader.readBsonType();
                        switch (bsonType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[bsonType.ordinal()]) {
                            case 1: {
                                writer.writeString(jsonReader.readString());
                                break block1;
                            }
                            case 2: {
                                writer.writeDouble(jsonReader.readDouble());
                                break block1;
                            }
                            case 3: {
                                writer.writeInt64(jsonReader.readInt64());
                                break block1;
                            }
                            case 4: {
                                writer.writeInt32(jsonReader.readInt32());
                                break block1;
                            }
                            case 5: {
                                writer.writeBoolean(jsonReader.readBoolean());
                                break block1;
                            }
                            case 6: {
                                writer.writeObjectId(jsonReader.readObjectId());
                                break block1;
                            }
                            case 7: {
                                writer.writeDateTime(jsonReader.readDateTime());
                                break block1;
                            }
                            case 8: {
                                writer.writeBinaryData(jsonReader.readBinaryData());
                                break block1;
                            }
                            case 9: {
                                writer.writeDecimal128(jsonReader.readDecimal128());
                                break block1;
                            }
                            case 10: {
                                writer.writeTimestamp(jsonReader.readTimestamp());
                                break block1;
                            }
                            case 11: {
                                Unit unit;
                                writer.writeNull();
                                Unit it = unit = Unit.INSTANCE;
                                boolean bl = false;
                                jsonReader.readNull();
                                break block1;
                            }
                        }
                        VisitorWrapper.JsonType jsonType2 = visitor2.getJsonType();
                        switch (jsonType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonType2.ordinal()]) {
                            case 1: {
                                writer.writeDouble(jsonReader.readDouble());
                                break block1;
                            }
                            case 2: {
                                writer.writeInt64(jsonReader.readInt64());
                                break block1;
                            }
                            case 3: {
                                writer.writeBoolean(jsonReader.readBoolean());
                                break block1;
                            }
                            case 4: {
                                writer.writeObjectId(jsonReader.readObjectId());
                                break block1;
                            }
                            case 5: {
                                writer.writeDateTime(jsonReader.readDateTime());
                                break block1;
                            }
                        }
                        writer.writeString(jsonReader.readString());
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @NotNull
    public Class<T> getEncoderClass() {
        return this.type;
    }

    @Override
    @NotNull
    public BsonValue getDocumentId(@NotNull T document2) {
        BsonValue idValue;
        KProperty1<?, ?> idProperty;
        Intrinsics.checkNotNullParameter(document2, "document");
        KProperty1<?, ?> kProperty1 = MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(document2.getClass()));
        KProperty1<Object, Object> kProperty12 = idProperty = kProperty1 instanceof KProperty1 ? kProperty1 : null;
        if (idProperty == null) {
            throw new IllegalStateException(this.type + " has no id field");
        }
        BsonValue bsonValue = idValue = KMongoUtil.INSTANCE.getIdBsonValue(idProperty.get(document2));
        if (bsonValue == null) {
            throw new IllegalStateException(this.type + " has null id");
        }
        return bsonValue;
    }

    @Override
    public boolean documentHasId(@NotNull T document2) {
        Intrinsics.checkNotNullParameter(document2, "document");
        return MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(document2.getClass())) != null;
    }

    @Override
    @NotNull
    public T generateIdIfAbsentFromDocument(@NotNull T document2) {
        Object idValue;
        KProperty1<?, ?> idProperty;
        Intrinsics.checkNotNullParameter(document2, "document");
        KProperty1<?, ?> kProperty1 = MongoIdUtil.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(document2.getClass()));
        KProperty1<Object, Object> kProperty12 = idProperty = kProperty1 instanceof KProperty1 ? kProperty1 : null;
        if (idProperty != null && (idValue = MongoIdUtil.INSTANCE.getIdValue(idProperty, document2)) == null) {
            Field field = ReflectJvmMapping.getJavaField((KProperty)idProperty);
            Intrinsics.checkNotNull(field);
            Field javaField = field;
            Class<?> type2 = javaField.getType();
            javaField.setAccessible(true);
            Intrinsics.checkNotNullExpressionValue(type2, "type");
            javaField.set(document2, KMongoUtil.INSTANCE.generateNewIdForIdClass(JvmClassMappingKt.getKotlinClass(type2)));
        }
        return document2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/JacksonCodec$VisitorWrapper;", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonFormatVisitorWrapper$Base;", "()V", "dateTimeClasses", "", "", "jsonType", "Lcom/willfp/eco/libs/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;", "getJsonType", "()Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;", "setJsonType", "(Lorg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;)V", "expectAnyFormat", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonAnyFormatVisitor;", "type", "Lcom/willfp/eco/libs/jackson/databind/JavaType;", "expectArrayFormat", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonArrayFormatVisitor;", "expectBooleanFormat", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonBooleanFormatVisitor;", "expectIntegerFormat", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonIntegerFormatVisitor;", "expectMapFormat", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonMapFormatVisitor;", "expectNullFormat", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonNullFormatVisitor;", "expectNumberFormat", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonNumberFormatVisitor;", "expectObjectFormat", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonObjectFormatVisitor;", "expectStringFormat", "Lcom/willfp/eco/libs/jackson/databind/jsonFormatVisitors/JsonStringFormatVisitor;", "JsonType", "kmongo-jackson-mapping"})
    @SourceDebugExtension(value={"SMAP\nJacksonCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JacksonCodec.kt\norg/litote/kmongo/jackson/JacksonCodec$VisitorWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
    public static final class VisitorWrapper
    extends JsonFormatVisitorWrapper.Base {
        @Nullable
        private JsonType jsonType;
        @NotNull
        private final Set<Object> dateTimeClasses;

        public VisitorWrapper() {
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Instant.class), Reflection.getOrCreateKotlinClass(ZonedDateTime.class), Reflection.getOrCreateKotlinClass(OffsetDateTime.class), Reflection.getOrCreateKotlinClass(LocalDate.class), Reflection.getOrCreateKotlinClass(LocalDateTime.class), Reflection.getOrCreateKotlinClass(LocalTime.class), Reflection.getOrCreateKotlinClass(OffsetTime.class)};
            this.dateTimeClasses = SetsKt.plus(SetsKt.setOf(kClassArray), (Iterable)KotlinxDatetimeLoader.INSTANCE.loadKotlinxDateTime(dateTimeClasses.1.INSTANCE, dateTimeClasses.2.INSTANCE));
        }

        @Nullable
        public final JsonType getJsonType() {
            return this.jsonType;
        }

        public final void setJsonType(@Nullable JsonType jsonType) {
            this.jsonType = jsonType;
        }

        @Override
        @Nullable
        public JsonNullFormatVisitor expectNullFormat(@Nullable JavaType type2) {
            return null;
        }

        @Override
        @Nullable
        public JsonAnyFormatVisitor expectAnyFormat(@NotNull JavaType type2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(type2, "type");
            Class<?> clazz = type2.getRawClass();
            if (clazz != null) {
                Class<?> it = clazz;
                boolean bl2 = false;
                bl = Id.class.isAssignableFrom(it);
            } else {
                bl = false;
            }
            if (bl) {
                this.jsonType = Intrinsics.areEqual(type2.getRawClass(), StringId.class) ? JsonType.string : JsonType.objectId;
            } else {
                Class<?> clazz2 = type2.getRawClass();
                Intrinsics.checkNotNullExpressionValue(clazz2, "type.rawClass");
                this.jsonType = this.dateTimeClasses.contains(JvmClassMappingKt.getKotlinClass(clazz2)) || Calendar.class.isAssignableFrom(type2.getRawClass()) ? JsonType.date : JsonType.object;
            }
            return null;
        }

        @Override
        @Nullable
        public JsonStringFormatVisitor expectStringFormat(@Nullable JavaType type2) {
            this.jsonType = JsonType.string;
            return null;
        }

        @Override
        @Nullable
        public JsonArrayFormatVisitor expectArrayFormat(@Nullable JavaType type2) {
            this.jsonType = JsonType.array;
            return null;
        }

        @Override
        @Nullable
        public JsonNumberFormatVisitor expectNumberFormat(@Nullable JavaType type2) {
            this.jsonType = JsonType.number;
            return null;
        }

        @Override
        @Nullable
        public JsonMapFormatVisitor expectMapFormat(@Nullable JavaType type2) {
            this.jsonType = JsonType.map;
            return null;
        }

        @Override
        @Nullable
        public JsonObjectFormatVisitor expectObjectFormat(@Nullable JavaType type2) {
            this.jsonType = JsonType.object;
            return null;
        }

        @Override
        @Nullable
        public JsonIntegerFormatVisitor expectIntegerFormat(@Nullable JavaType type2) {
            this.jsonType = JsonType.integer;
            return null;
        }

        @Override
        @Nullable
        public JsonBooleanFormatVisitor expectBooleanFormat(@Nullable JavaType type2) {
            this.jsonType = JsonType.boolean;
            return null;
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/JacksonCodec$VisitorWrapper$JsonType;", "", "(Ljava/lang/String;I)V", "string", "array", "number", "map", "object", "integer", "boolean", "objectId", "date", "kmongo-jackson-mapping"})
        public static final class JsonType
        extends Enum<JsonType> {
            public static final /* enum */ JsonType string = new JsonType();
            public static final /* enum */ JsonType array = new JsonType();
            public static final /* enum */ JsonType number = new JsonType();
            public static final /* enum */ JsonType map = new JsonType();
            public static final /* enum */ JsonType object = new JsonType();
            public static final /* enum */ JsonType integer = new JsonType();
            public static final /* enum */ JsonType boolean = new JsonType();
            public static final /* enum */ JsonType objectId = new JsonType();
            public static final /* enum */ JsonType date = new JsonType();
            private static final /* synthetic */ JsonType[] $VALUES;

            public static JsonType[] values() {
                return (JsonType[])$VALUES.clone();
            }

            public static JsonType valueOf(String value) {
                return Enum.valueOf(JsonType.class, value);
            }

            static {
                $VALUES = jsonTypeArray = new JsonType[]{JsonType.string, JsonType.array, JsonType.number, JsonType.map, JsonType.object, JsonType.integer, JsonType.boolean, JsonType.objectId, JsonType.date};
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VisitorWrapper.JsonType.values().length];
            try {
                nArray[VisitorWrapper.JsonType.number.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorWrapper.JsonType.integer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorWrapper.JsonType.boolean.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorWrapper.JsonType.objectId.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorWrapper.JsonType.date.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorWrapper.JsonType.object.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorWrapper.JsonType.map.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorWrapper.JsonType.array.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VisitorWrapper.JsonType.string.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BsonType.values().length];
            try {
                nArray[BsonType.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DOUBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.INT64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.INT32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.BOOLEAN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.OBJECT_ID.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DATE_TIME.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.BINARY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.DECIMAL128.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.TIMESTAMP.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BsonType.NULL.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

