/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb;

import com.willfp.eco.libs.mongodb.ReadConcern;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.WriteConcern;
import com.willfp.eco.libs.mongodb.annotations.Immutable;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
public final class TransactionOptions {
    private final ReadConcern readConcern;
    private final WriteConcern writeConcern;
    private final ReadPreference readPreference;
    private final Long maxCommitTimeMS;

    @Nullable
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Nullable
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Nullable
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Nullable
    public Long getMaxCommitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.maxCommitTimeMS == null) {
            return null;
        }
        return timeUnit.convert(this.maxCommitTimeMS, TimeUnit.MILLISECONDS);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TransactionOptions merge(TransactionOptions options2, TransactionOptions defaultOptions) {
        Assertions.notNull("options", options2);
        Assertions.notNull("defaultOptions", defaultOptions);
        return TransactionOptions.builder().writeConcern(options2.getWriteConcern() == null ? defaultOptions.getWriteConcern() : options2.getWriteConcern()).readConcern(options2.getReadConcern() == null ? defaultOptions.getReadConcern() : options2.getReadConcern()).readPreference(options2.getReadPreference() == null ? defaultOptions.getReadPreference() : options2.getReadPreference()).maxCommitTime(options2.getMaxCommitTime(TimeUnit.MILLISECONDS) == null ? defaultOptions.getMaxCommitTime(TimeUnit.MILLISECONDS) : options2.getMaxCommitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOptions that = (TransactionOptions)o;
        if (!Objects.equals(this.maxCommitTimeMS, that.maxCommitTimeMS)) {
            return false;
        }
        if (!Objects.equals(this.readConcern, that.readConcern)) {
            return false;
        }
        if (!Objects.equals(this.writeConcern, that.writeConcern)) {
            return false;
        }
        return Objects.equals(this.readPreference, that.readPreference);
    }

    public int hashCode() {
        int result2 = this.readConcern != null ? this.readConcern.hashCode() : 0;
        result2 = 31 * result2 + (this.writeConcern != null ? this.writeConcern.hashCode() : 0);
        result2 = 31 * result2 + (this.readPreference != null ? this.readPreference.hashCode() : 0);
        result2 = 31 * result2 + (this.maxCommitTimeMS != null ? this.maxCommitTimeMS.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "TransactionOptions{readConcern=" + this.readConcern + ", writeConcern=" + this.writeConcern + ", readPreference=" + this.readPreference + ", maxCommitTimeMS" + this.maxCommitTimeMS + '}';
    }

    private TransactionOptions(Builder builder) {
        this.readConcern = builder.readConcern;
        this.writeConcern = builder.writeConcern;
        this.readPreference = builder.readPreference;
        this.maxCommitTimeMS = builder.maxCommitTimeMS;
    }

    public static final class Builder {
        private ReadConcern readConcern;
        private WriteConcern writeConcern;
        private ReadPreference readPreference;
        private Long maxCommitTimeMS;

        public Builder readConcern(@Nullable ReadConcern readConcern) {
            this.readConcern = readConcern;
            return this;
        }

        public Builder writeConcern(@Nullable WriteConcern writeConcern) {
            this.writeConcern = writeConcern;
            return this;
        }

        public Builder readPreference(@Nullable ReadPreference readPreference) {
            this.readPreference = readPreference;
            return this;
        }

        public Builder maxCommitTime(@Nullable Long maxCommitTime, TimeUnit timeUnit) {
            if (maxCommitTime == null) {
                this.maxCommitTimeMS = null;
            } else {
                Assertions.notNull("timeUnit", timeUnit);
                Assertions.isTrueArgument("maxCommitTime > 0", maxCommitTime > 0L);
                this.maxCommitTimeMS = TimeUnit.MILLISECONDS.convert(maxCommitTime, timeUnit);
            }
            return this;
        }

        public TransactionOptions build() {
            return new TransactionOptions(this);
        }

        private Builder() {
        }
    }
}

