/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.client.gridfs.model;

import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.types.ObjectId;
import com.willfp.eco.libs.mongodb.MongoGridFSException;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.Date;
import java.util.Objects;

public final class GridFSFile {
    private final BsonValue id;
    private final String filename;
    private final long length;
    private final int chunkSize;
    private final Date uploadDate;
    private final Document metadata;

    public GridFSFile(BsonValue id2, String filename, long length, int chunkSize, Date uploadDate, @Nullable Document metadata2) {
        this.id = Assertions.notNull("id", id2);
        this.filename = Assertions.notNull("filename", filename);
        this.length = Assertions.notNull("length", length);
        this.chunkSize = Assertions.notNull("chunkSize", chunkSize);
        this.uploadDate = Assertions.notNull("uploadDate", uploadDate);
        this.metadata = metadata2 != null && metadata2.isEmpty() ? null : metadata2;
    }

    public ObjectId getObjectId() {
        if (!this.id.isObjectId()) {
            throw new MongoGridFSException("Custom id type used for this GridFS file");
        }
        return this.id.asObjectId().getValue();
    }

    public BsonValue getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getLength() {
        return this.length;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    @Nullable
    public Document getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridFSFile that = (GridFSFile)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!this.filename.equals(that.filename)) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        if (this.chunkSize != that.chunkSize) {
            return false;
        }
        if (!this.uploadDate.equals(that.uploadDate)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        int result2 = this.id != null ? this.id.hashCode() : 0;
        result2 = 31 * result2 + this.filename.hashCode();
        result2 = 31 * result2 + (int)(this.length ^ this.length >>> 32);
        result2 = 31 * result2 + this.chunkSize;
        result2 = 31 * result2 + this.uploadDate.hashCode();
        result2 = 31 * result2 + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "GridFSFile{id=" + this.id + ", filename='" + this.filename + '\'' + ", length=" + this.length + ", chunkSize=" + this.chunkSize + ", uploadDate=" + this.uploadDate + ", metadata=" + this.metadata + '}';
    }
}

