/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.client.model;

import com.willfp.eco.libs.mongodb.assertions.Assertions;
import java.util.Objects;

public class Field<TExpression> {
    private final String name;
    private final TExpression value;

    public Field(String name, TExpression value) {
        this.name = Assertions.notNull("name", name);
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public TExpression getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field field = (Field)o;
        if (!this.name.equals(field.name)) {
            return false;
        }
        return Objects.equals(this.value, field.value);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "Field{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }
}

